/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.AutoValue_TFRecordIO_Read;
import org.apache.beam.sdk.io.AutoValue_TFRecordIO_ReadFiles;
import org.apache.beam.sdk.io.AutoValue_TFRecordIO_Write;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.DynamicFileDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSource;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TFRecordIO {
    public static final Coder<byte[]> DEFAULT_BYTE_ARRAY_CODER = ByteArrayCoder.of();

    public static Read read() {
        return new AutoValue_TFRecordIO_Read.Builder().setValidate(true).setCompression(Compression.AUTO).build();
    }

    public static ReadFiles readFiles() {
        return new AutoValue_TFRecordIO_ReadFiles.Builder().build();
    }

    public static Write write() {
        return new AutoValue_TFRecordIO_Write.Builder().setShardTemplate(null).setFilenameSuffix(null).setNumShards(0).setCompression(Compression.UNCOMPRESSED).setNoSpilling(false).build();
    }

    public static Sink sink() {
        return new Sink();
    }

    private TFRecordIO() {
    }

    @VisibleForTesting
    static class TFRecordCodec {
        private static final int HEADER_LEN = 12;
        private static final int FOOTER_LEN = 4;
        private static HashFunction crc32c = Hashing.crc32c();
        private ByteBuffer header = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        private ByteBuffer footer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);

        TFRecordCodec() {
        }

        private int mask(int crc) {
            return (crc >>> 15 | crc << 17) + -1568478504;
        }

        private int hashLong(long x) {
            return this.mask(crc32c.hashLong(x).asInt());
        }

        private int hashBytes(byte[] x) {
            return this.mask(crc32c.hashBytes(x).asInt());
        }

        public int recordLength(byte[] data) {
            return 12 + data.length + 4;
        }

        public byte @Nullable [] read(ReadableByteChannel inChannel) throws IOException {
            this.header.clear();
            int headerBytes = TFRecordCodec.read(inChannel, this.header);
            if (headerBytes == 0) {
                return null;
            }
            Preconditions.checkState(headerBytes == 12, "Not a valid TFRecord. Fewer than 12 bytes.");
            this.header.rewind();
            long length64 = this.header.getLong();
            long lengthHash = this.hashLong(length64);
            int maskedCrc32OfLength = this.header.getInt();
            if (lengthHash != (long)maskedCrc32OfLength) {
                throw new IOException(String.format("Mismatch of length mask when reading a record. Expected %d but received %d.", maskedCrc32OfLength, lengthHash));
            }
            int length = (int)length64;
            if ((long)length != length64) {
                throw new IOException(String.format("length overflow %d", length64));
            }
            ByteBuffer data = ByteBuffer.allocate(length);
            TFRecordCodec.readFully(inChannel, data);
            this.footer.clear();
            TFRecordCodec.readFully(inChannel, this.footer);
            this.footer.rewind();
            int maskedCrc32OfData = this.footer.getInt();
            int dataHash = this.hashBytes(data.array());
            if (dataHash != maskedCrc32OfData) {
                throw new IOException(String.format("Mismatch of data mask when reading a record. Expected %d but received %d.", maskedCrc32OfData, dataHash));
            }
            return data.array();
        }

        public void write(WritableByteChannel outChannel, byte[] data) throws IOException {
            int maskedCrc32OfLength = this.hashLong(data.length);
            int maskedCrc32OfData = this.hashBytes(data);
            this.header.clear();
            this.header.putLong(data.length).putInt(maskedCrc32OfLength);
            this.header.rewind();
            TFRecordCodec.writeFully(outChannel, this.header);
            TFRecordCodec.writeFully(outChannel, ByteBuffer.wrap(data));
            this.footer.clear();
            this.footer.putInt(maskedCrc32OfData);
            this.footer.rewind();
            TFRecordCodec.writeFully(outChannel, this.footer);
        }

        @VisibleForTesting
        static void readFully(ReadableByteChannel in, ByteBuffer bb) throws IOException {
            int actual;
            int expected = bb.remaining();
            if (expected != (actual = TFRecordCodec.read(in, bb))) {
                throw new IOException(String.format("expected %d, but got %d", expected, actual));
            }
        }

        private static int read(ReadableByteChannel in, ByteBuffer bb) throws IOException {
            int expected = bb.remaining();
            while (bb.hasRemaining() && in.read(bb) >= 0) {
            }
            return expected - bb.remaining();
        }

        @VisibleForTesting
        static void writeFully(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
            while (buffer.hasRemaining()) {
                channel.write(buffer);
            }
        }
    }

    @VisibleForTesting
    static class TFRecordSink
    extends FileBasedSink<byte[], Void, byte[]> {
        @VisibleForTesting
        TFRecordSink(ValueProvider<ResourceId> outputPrefix, @Nullable String shardTemplate, @Nullable String suffix, Compression compression) {
            super(outputPrefix, DynamicFileDestinations.constant(DefaultFilenamePolicy.fromStandardParameters(outputPrefix, shardTemplate, suffix, false)), compression);
        }

        @Override
        public FileBasedSink.WriteOperation<Void, byte[]> createWriteOperation() {
            return new TFRecordWriteOperation(this);
        }

        private static class TFRecordWriter
        extends FileBasedSink.Writer<Void, byte[]> {
            private @Nullable WritableByteChannel outChannel;
            private @Nullable TFRecordCodec codec;

            private TFRecordWriter(FileBasedSink.WriteOperation<Void, byte[]> writeOperation) {
                super(writeOperation, "application/octet-stream");
            }

            @Override
            protected void prepareWrite(WritableByteChannel channel) throws Exception {
                this.outChannel = channel;
                this.codec = new TFRecordCodec();
            }

            @Override
            public void write(byte[] value) throws Exception {
                this.codec.write(this.outChannel, value);
            }
        }

        private static class TFRecordWriteOperation
        extends FileBasedSink.WriteOperation<Void, byte[]> {
            private TFRecordWriteOperation(TFRecordSink sink) {
                super(sink);
            }

            @Override
            public FileBasedSink.Writer<Void, byte[]> createWriter() throws Exception {
                return new TFRecordWriter((FileBasedSink.WriteOperation)this);
            }
        }
    }

    @VisibleForTesting
    static class TFRecordSource
    extends FileBasedSource<byte[]> {
        @VisibleForTesting
        TFRecordSource(ValueProvider<String> fileSpec) {
            super(fileSpec, Long.MAX_VALUE);
        }

        private TFRecordSource(MatchResult.Metadata metadata, long start, long end) {
            super(metadata, Long.MAX_VALUE, start, end);
        }

        @Override
        protected FileBasedSource<byte[]> createForSubrangeOfFile(MatchResult.Metadata metadata, long start, long end) {
            Preconditions.checkArgument(start == 0L, "TFRecordSource is not splittable");
            return new TFRecordSource(metadata, start, end);
        }

        @Override
        protected FileBasedSource.FileBasedReader<byte[]> createSingleFileReader(PipelineOptions options) {
            return new TFRecordReader(this);
        }

        @Override
        public Coder<byte[]> getOutputCoder() {
            return DEFAULT_BYTE_ARRAY_CODER;
        }

        @Override
        protected boolean isSplittable() {
            return false;
        }

        @VisibleForTesting
        static class TFRecordReader
        extends FileBasedSource.FileBasedReader<byte[]> {
            private long startOfRecord;
            private volatile long startOfNextRecord;
            private volatile boolean elementIsPresent;
            private byte @Nullable [] currentValue;
            private @Nullable ReadableByteChannel inChannel;
            private @Nullable TFRecordCodec codec;

            private TFRecordReader(TFRecordSource source) {
                super(source);
            }

            @Override
            public boolean allowsDynamicSplitting() {
                return false;
            }

            @Override
            protected long getCurrentOffset() throws NoSuchElementException {
                if (!this.elementIsPresent) {
                    throw new NoSuchElementException();
                }
                return this.startOfRecord;
            }

            @Override
            public byte[] getCurrent() throws NoSuchElementException {
                if (!this.elementIsPresent) {
                    throw new NoSuchElementException();
                }
                return this.currentValue;
            }

            @Override
            protected void startReading(ReadableByteChannel channel) throws IOException {
                this.inChannel = channel;
                this.codec = new TFRecordCodec();
            }

            @Override
            protected boolean readNextRecord() throws IOException {
                this.startOfRecord = this.startOfNextRecord;
                this.currentValue = this.codec.read(this.inChannel);
                if (this.currentValue != null) {
                    this.elementIsPresent = true;
                    this.startOfNextRecord = this.startOfRecord + (long)this.codec.recordLength(this.currentValue);
                    return true;
                }
                this.elementIsPresent = false;
                return false;
            }
        }
    }

    @Deprecated
    public static enum CompressionType {
        AUTO(Compression.AUTO),
        NONE(Compression.UNCOMPRESSED),
        GZIP(Compression.GZIP),
        ZLIB(Compression.DEFLATE);

        private final Compression canonical;

        private CompressionType(Compression canonical) {
            this.canonical = canonical;
        }

        public boolean matches(String filename) {
            return this.canonical.matches(filename);
        }
    }

    public static class Sink
    implements FileIO.Sink<byte[]> {
        private transient @Nullable WritableByteChannel channel;
        private transient @Nullable TFRecordCodec codec;

        @Override
        public void open(WritableByteChannel channel) throws IOException {
            this.channel = channel;
            this.codec = new TFRecordCodec();
        }

        @Override
        public void write(byte[] element) throws IOException {
            this.codec.write(this.channel, element);
        }

        @Override
        public void flush() throws IOException {
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<byte[]>, PDone> {
        abstract @Nullable ValueProvider<ResourceId> getOutputPrefix();

        abstract @Nullable String getFilenameSuffix();

        abstract int getNumShards();

        abstract @Nullable String getShardTemplate();

        abstract Compression getCompression();

        abstract boolean getNoSpilling();

        abstract Builder toBuilder();

        public Write to(String outputPrefix) {
            return this.to(FileBasedSink.convertToFileResourceIfPossible(outputPrefix));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write to(ResourceId outputResource) {
            return this.toResource(ValueProvider.StaticValueProvider.of(outputResource));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write toResource(ValueProvider<ResourceId> outputResource) {
            return this.toBuilder().setOutputPrefix(outputResource).build();
        }

        public Write withSuffix(String suffix) {
            return this.toBuilder().setFilenameSuffix(suffix).build();
        }

        public Write withNumShards(int numShards) {
            Preconditions.checkArgument(numShards >= 0, "Number of shards %s must be >= 0", numShards);
            return this.toBuilder().setNumShards(numShards).build();
        }

        public Write withShardNameTemplate(String shardTemplate) {
            return this.toBuilder().setShardTemplate(shardTemplate).build();
        }

        public Write withoutSharding() {
            return this.withNumShards(1).withShardNameTemplate("");
        }

        @Deprecated
        public Write withCompressionType(CompressionType compressionType) {
            return this.withCompression(compressionType.canonical);
        }

        public Write withCompression(Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        public Write withNoSpilling() {
            return this.toBuilder().setNoSpilling(true).build();
        }

        @Override
        public PDone expand(PCollection<byte[]> input) {
            Preconditions.checkState(this.getOutputPrefix() != null, "need to set the output prefix of a TFRecordIO.Write transform");
            WriteFiles<byte[], Void, byte[]> write = WriteFiles.to(new TFRecordSink(this.getOutputPrefix(), this.getShardTemplate(), this.getFilenameSuffix(), this.getCompression()));
            if (this.getNumShards() > 0) {
                write = write.withNumShards(this.getNumShards());
            }
            if (this.getNoSpilling()) {
                write = write.withNoSpilling();
            }
            input.apply("Write", write);
            return PDone.in(input.getPipeline());
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("filePrefix", this.getOutputPrefix()).withLabel("Output File Prefix")).addIfNotNull(DisplayData.item("fileSuffix", this.getFilenameSuffix()).withLabel("Output File Suffix")).addIfNotNull(DisplayData.item("shardNameTemplate", this.getShardTemplate()).withLabel("Output Shard Name Template")).addIfNotDefault(DisplayData.item("numShards", this.getNumShards()).withLabel("Maximum Output Shards"), 0).add(DisplayData.item("compressionType", this.getCompression().toString()).withLabel("Compression Type"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setOutputPrefix(ValueProvider<ResourceId> var1);

            abstract Builder setShardTemplate(@Nullable String var1);

            abstract Builder setFilenameSuffix(@Nullable String var1);

            abstract Builder setNumShards(int var1);

            abstract Builder setCompression(Compression var1);

            abstract Builder setNoSpilling(boolean var1);

            abstract Write build();
        }
    }

    @AutoValue
    public static abstract class ReadFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<byte[]>> {
        abstract Builder toBuilder();

        @Override
        public PCollection<byte[]> expand(PCollection<FileIO.ReadableFile> input) {
            return (PCollection)input.apply("Read all via FileBasedSource", new ReadAllViaFileBasedSource<byte[]>(Long.MAX_VALUE, new CreateSourceFn(), DEFAULT_BYTE_ARRAY_CODER));
        }

        private static class CreateSourceFn
        implements SerializableFunction<String, FileBasedSource<byte[]>> {
            private CreateSourceFn() {
            }

            @Override
            public FileBasedSource<byte[]> apply(String input) {
                return new TFRecordSource(ValueProvider.StaticValueProvider.of(input));
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract ReadFiles build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<byte[]>> {
        abstract @Nullable ValueProvider<String> getFilepattern();

        abstract boolean getValidate();

        abstract Compression getCompression();

        abstract Builder toBuilder();

        public Read from(String filepattern) {
            return this.from(ValueProvider.StaticValueProvider.of(filepattern));
        }

        public Read from(ValueProvider<String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public Read withoutValidation() {
            return this.toBuilder().setValidate(false).build();
        }

        @Deprecated
        public Read withCompressionType(CompressionType compressionType) {
            return this.withCompression(compressionType.canonical);
        }

        public Read withCompression(Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        @Override
        public PCollection<byte[]> expand(PBegin input) {
            if (this.getFilepattern() == null) {
                throw new IllegalStateException("Need to set the filepattern of a TFRecordIO.Read transform");
            }
            if (this.getValidate()) {
                Preconditions.checkState(this.getFilepattern().isAccessible(), "Cannot validate with a RVP.");
                try {
                    MatchResult matches = FileSystems.match(this.getFilepattern().get());
                    Preconditions.checkState(!matches.metadata().isEmpty(), "Unable to find any files matching %s", (Object)this.getFilepattern().get());
                }
                catch (IOException e) {
                    throw new IllegalStateException(String.format("Failed to validate %s", this.getFilepattern().get()), e);
                }
            }
            return (PCollection)input.apply("Read", org.apache.beam.sdk.io.Read.from(this.getSource()));
        }

        protected FileBasedSource<byte[]> getSource() {
            return CompressedSource.from(new TFRecordSource(this.getFilepattern())).withCompression(this.getCompression());
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("compressionType", this.getCompression().toString()).withLabel("Compression Type")).addIfNotDefault(DisplayData.item("validation", this.getValidate()).withLabel("Validation Enabled"), true).addIfNotNull(DisplayData.item("filePattern", this.getFilepattern()).withLabel("File Pattern"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setFilepattern(ValueProvider<String> var1);

            abstract Builder setValidate(boolean var1);

            abstract Builder setCompression(Compression var1);

            abstract Read build();
        }
    }
}

