/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;

@Internal
public class DelegatingDistribution
implements Metric,
Distribution,
Serializable {
    private final MetricName name;
    private final boolean processWideContainer;

    public DelegatingDistribution(MetricName name) {
        this(name, false);
    }

    public DelegatingDistribution(MetricName name, boolean processWideContainer) {
        this.name = name;
        this.processWideContainer = processWideContainer;
    }

    @Override
    public void update(long value) {
        MetricsContainer container;
        MetricsContainer metricsContainer = container = this.processWideContainer ? MetricsEnvironment.getProcessWideContainer() : MetricsEnvironment.getCurrentContainer();
        if (container != null) {
            container.getDistribution(this.name).update(value);
        }
    }

    @Override
    public void update(long sum, long count, long min2, long max) {
        MetricsContainer container;
        MetricsContainer metricsContainer = container = this.processWideContainer ? MetricsEnvironment.getProcessWideContainer() : MetricsEnvironment.getCurrentContainer();
        if (container != null) {
            container.getDistribution(this.name).update(sum, count, min2, max);
        }
    }

    @Override
    public MetricName getName() {
        return this.name;
    }
}

