/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.AutoValue_Schema_Field;
import org.apache.beam.sdk.schemas.AutoValue_Schema_FieldType;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.SchemaVerification;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Schema
implements Serializable {
    private final BiMap<String, Integer> fieldIndices = HashBiMap.create();
    private Map<String, Integer> encodingPositions = Maps.newHashMap();
    private boolean encodingPositionsOverridden = false;
    private final List<Field> fields;
    private final int hashCode;
    private @Nullable UUID uuid = null;
    private final Options options;

    public static Builder builder() {
        return new Builder();
    }

    public Schema(List<Field> fields) {
        this(fields, Options.none());
    }

    public Schema(List<Field> fields, Options options) {
        this.fields = fields;
        int index = 0;
        for (Field field : fields) {
            Preconditions.checkArgument(this.fieldIndices.get(field.getName()) == null, "Duplicate field " + field.getName() + " added to schema");
            this.encodingPositions.put(field.getName(), index);
            this.fieldIndices.put(field.getName(), index++);
        }
        this.hashCode = Objects.hash(this.fieldIndices, fields);
        this.options = options;
    }

    public static Schema of(Field ... fields) {
        return Schema.builder().addFields(fields).build();
    }

    public Schema withOptions(Options options) {
        return new Schema(this.fields, this.getOptions().toBuilder().addOptions(options).build());
    }

    public Schema withOptions(Options.Builder optionsBuilder) {
        return this.withOptions(optionsBuilder.build());
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public Map<String, Integer> getEncodingPositions() {
        return this.encodingPositions;
    }

    public boolean isEncodingPositionsOverridden() {
        return this.encodingPositionsOverridden;
    }

    public void setEncodingPositions(Map<String, Integer> encodingPositions) {
        this.encodingPositions = encodingPositions;
        this.encodingPositionsOverridden = true;
    }

    public @Nullable UUID getUUID() {
        return this.uuid;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema other = (Schema)o;
        if (this.uuid != null && other.uuid != null && Objects.equals(this.uuid, other.uuid)) {
            return true;
        }
        return Objects.equals(this.fieldIndices, other.fieldIndices) && Objects.equals(this.getFields(), other.getFields()) && Objects.equals(this.getOptions(), other.getOptions());
    }

    public boolean typesEqual(Schema other) {
        if (this.uuid != null && other.uuid != null && Objects.equals(this.uuid, other.uuid)) {
            return true;
        }
        if (this.getFieldCount() != other.getFieldCount()) {
            return false;
        }
        if (!Objects.equals(this.fieldIndices.values(), other.fieldIndices.values())) {
            return false;
        }
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (this.getField(i).typesEqual(other.getField(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equivalent(Schema other) {
        return this.equivalent(other, EquivalenceNullablePolicy.SAME);
    }

    public boolean assignableTo(Schema other) {
        return this.equivalent(other, EquivalenceNullablePolicy.WEAKEN);
    }

    public boolean assignableToIgnoreNullable(Schema other) {
        return this.equivalent(other, EquivalenceNullablePolicy.IGNORE);
    }

    private boolean equivalent(Schema other, EquivalenceNullablePolicy nullablePolicy) {
        if (other.getFieldCount() != this.getFieldCount()) {
            return false;
        }
        List otherFields = other.getFields().stream().sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
        List actualFields = this.getFields().stream().sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
        for (int i = 0; i < otherFields.size(); ++i) {
            Field otherField = (Field)otherFields.get(i);
            Field actualField = (Field)actualFields.get(i);
            if (actualField.equivalent(otherField, nullablePolicy)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Fields:");
        builder.append(System.lineSeparator());
        for (Field field : this.fields) {
            builder.append(field);
            builder.append(System.lineSeparator());
        }
        builder.append("Encoding positions:");
        builder.append(System.lineSeparator());
        builder.append(this.encodingPositions);
        builder.append(System.lineSeparator());
        builder.append("Options:");
        builder.append(this.options);
        builder.append("UUID: " + this.uuid);
        return builder.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public static Collector<Field, List<Field>, Schema> toSchema() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Schema::fromFields, new Collector.Characteristics[0]);
    }

    private static Schema fromFields(List<Field> fields) {
        return new Schema(fields);
    }

    public List<String> getFieldNames() {
        return this.getFields().stream().map(Field::getName).collect(Collectors.toList());
    }

    public Field getField(int index) {
        return this.getFields().get(index);
    }

    public Field getField(String name) {
        return this.getFields().get(this.indexOf(name));
    }

    public int indexOf(String fieldName) {
        Integer index = (Integer)this.fieldIndices.get(fieldName);
        Preconditions.checkArgument(index != null, "Cannot find field %s in schema %s", (Object)fieldName, (Object)this);
        return index;
    }

    public boolean hasField(String fieldName) {
        return this.fieldIndices.containsKey(fieldName);
    }

    public String nameOf(int fieldIndex) {
        String name = (String)this.fieldIndices.inverse().get(fieldIndex);
        Preconditions.checkArgument(name != null, "Cannot find field %s", fieldIndex);
        return name;
    }

    public int getFieldCount() {
        return this.getFields().size();
    }

    public Options getOptions() {
        return this.options;
    }

    public static class Options
    implements Serializable {
        private final Map<String, Option> options;

        public String toString() {
            TreeMap<String, Option> sorted = new TreeMap<String, Option>(this.options);
            return "{" + sorted + '}';
        }

        Map<String, Option> getAllOptions() {
            return this.options;
        }

        public Set<String> getOptionNames() {
            return this.options.keySet();
        }

        public boolean hasOptions() {
            return this.options.size() > 0;
        }

        public boolean hasOption(String name) {
            return this.options.containsKey(name);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Options options1 = (Options)o;
            if (!this.options.keySet().equals(options1.options.keySet())) {
                return false;
            }
            for (Map.Entry<String, Option> optionEntry : this.options.entrySet()) {
                Option otherOption;
                Option thisOption = optionEntry.getValue();
                if (thisOption.equals(otherOption = options1.options.get(optionEntry.getKey()))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.options);
        }

        Options(Map<String, Option> options) {
            this.options = options;
        }

        Options() {
            this.options = new HashMap<String, Option>();
        }

        Builder toBuilder() {
            return new Builder(new HashMap<String, Option>(this.options));
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Options none() {
            return new Options();
        }

        public <T> T getValue(String optionName) {
            Option option = this.options.get(optionName);
            if (option != null) {
                return option.getValue();
            }
            throw new IllegalArgumentException(String.format("No option found with name %s.", optionName));
        }

        public <T> T getValue(String optionName, Class<T> valueClass) {
            return this.getValue(optionName);
        }

        public <T> T getValueOrDefault(String optionName, T defaultValue) {
            Option option = this.options.get(optionName);
            if (option != null) {
                return option.getValue();
            }
            return defaultValue;
        }

        public FieldType getType(String optionName) {
            Option option = this.options.get(optionName);
            if (option != null) {
                return option.getType();
            }
            throw new IllegalArgumentException(String.format("No option found with name %s.", optionName));
        }

        public static Builder setOption(String optionName, FieldType fieldType, Object value) {
            return Options.builder().setOption(optionName, fieldType, value);
        }

        public static Builder setOption(String optionName, Row value) {
            return Options.builder().setOption(optionName, value);
        }

        public static class Builder {
            private Map<String, Option> options;

            Builder(Map<String, Option> init) {
                this.options = new HashMap<String, Option>(init);
            }

            Builder() {
                this(new HashMap<String, Option>());
            }

            public Builder setOption(String optionName, Row value) {
                this.setOption(optionName, FieldType.row(value.getSchema()), value);
                return this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Builder setOption(String optionName, FieldType fieldType, Object value) {
                if (value == null) {
                    if (!fieldType.getNullable().booleanValue()) throw new IllegalArgumentException(String.format("Option %s is not nullable", optionName));
                    this.options.put(optionName, new Option(fieldType, null));
                    return this;
                } else {
                    this.options.put(optionName, new Option(fieldType, SchemaVerification.verifyFieldValue(value, fieldType, optionName)));
                }
                return this;
            }

            public Options build() {
                return new Options(this.options);
            }

            public Builder addOptions(Options options) {
                this.options.putAll(options.options);
                return this;
            }
        }

        static class Option
        implements Serializable {
            private FieldType type;
            private Object value;

            Option(FieldType type, Object value) {
                this.type = type;
                this.value = value;
            }

            <T> T getValue() {
                return (T)this.value;
            }

            FieldType getType() {
                return this.type;
            }

            public String toString() {
                return "Option{type=" + this.type + ", value=" + this.value + '}';
            }

            public boolean equals(@Nullable Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Option option = (Option)o;
                return Objects.equals(this.type, option.type) && Row.Equals.deepEquals(this.value, option.value, this.type);
            }

            public int hashCode() {
                return Row.Equals.deepHashCode(this.value, this.type);
            }
        }
    }

    @AutoValue
    public static abstract class Field
    implements Serializable {
        public abstract String getName();

        public abstract String getDescription();

        public abstract FieldType getType();

        public abstract Options getOptions();

        public abstract Builder toBuilder();

        public static Field of(String name, FieldType fieldType) {
            return new AutoValue_Schema_Field.Builder().setName(name).setDescription("").setType(fieldType).setOptions(Options.none()).build();
        }

        public static Field nullable(String name, FieldType fieldType) {
            return new AutoValue_Schema_Field.Builder().setName(name).setDescription("").setType(fieldType.withNullable(true)).setOptions(Options.none()).build();
        }

        public Field withName(String name) {
            return this.toBuilder().setName(name).build();
        }

        public Field withDescription(String description) {
            return this.toBuilder().setDescription(description).build();
        }

        public Field withType(FieldType fieldType) {
            return this.toBuilder().setType(fieldType).build();
        }

        public Field withNullable(boolean isNullable) {
            return this.toBuilder().setType(this.getType().withNullable(isNullable)).build();
        }

        public Field withOptions(Options options) {
            return this.toBuilder().setOptions(this.getOptions().toBuilder().addOptions(options).build()).build();
        }

        public Field withOptions(Options.Builder optionsBuilder) {
            return this.withOptions(optionsBuilder.build());
        }

        public final boolean equals(@Nullable Object o) {
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getType(), other.getType()) && Objects.equals(this.getOptions(), other.getOptions());
        }

        public boolean typesEqual(Field other) {
            return this.getType().typesEqual(other.getType());
        }

        private boolean equivalent(Field otherField, EquivalenceNullablePolicy nullablePolicy) {
            return this.getName().equals(otherField.getName()) && this.getType().equivalent(otherField.getType(), nullablePolicy);
        }

        public final int hashCode() {
            return Objects.hash(this.getName(), this.getDescription(), this.getType());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setName(String var1);

            public abstract Builder setDescription(String var1);

            public abstract Builder setType(FieldType var1);

            public abstract Builder setOptions(Options var1);

            public Builder setOptions(Options.Builder optionsBuilder) {
                this.setOptions(optionsBuilder.build());
                return this;
            }

            public abstract Field build();
        }
    }

    @AutoValue
    @Immutable
    public static abstract class FieldType
    implements Serializable {
        public static final FieldType STRING = FieldType.of(TypeName.STRING);
        public static final FieldType BYTE = FieldType.of(TypeName.BYTE);
        public static final FieldType BYTES = FieldType.of(TypeName.BYTES);
        public static final FieldType INT16 = FieldType.of(TypeName.INT16);
        public static final FieldType INT32 = FieldType.of(TypeName.INT32);
        public static final FieldType INT64 = FieldType.of(TypeName.INT64);
        public static final FieldType FLOAT = FieldType.of(TypeName.FLOAT);
        public static final FieldType DOUBLE = FieldType.of(TypeName.DOUBLE);
        public static final FieldType DECIMAL = FieldType.of(TypeName.DECIMAL);
        public static final FieldType BOOLEAN = FieldType.of(TypeName.BOOLEAN);
        public static final FieldType DATETIME = FieldType.of(TypeName.DATETIME);

        public abstract TypeName getTypeName();

        public abstract Boolean getNullable();

        public abstract @Nullable LogicalType getLogicalType();

        public abstract @Nullable FieldType getCollectionElementType();

        public abstract @Nullable FieldType getMapKeyType();

        public abstract @Nullable FieldType getMapValueType();

        public abstract @Nullable Schema getRowSchema();

        @Deprecated
        abstract Map<String, ByteArrayWrapper> getMetadata();

        public abstract Builder toBuilder();

        public boolean isLogicalType(String logicalTypeIdentifier) {
            return this.getTypeName().isLogicalType() && this.getLogicalType().getIdentifier().equals(logicalTypeIdentifier);
        }

        public <LogicalTypeT extends LogicalType> LogicalTypeT getLogicalType(Class<LogicalTypeT> logicalTypeClass) {
            return (LogicalTypeT)((LogicalType)logicalTypeClass.cast(this.getLogicalType()));
        }

        public static Builder forTypeName(TypeName typeName) {
            return new AutoValue_Schema_FieldType.Builder().setTypeName(typeName).setNullable(false).setMetadata(Collections.emptyMap());
        }

        public static FieldType of(TypeName typeName) {
            return FieldType.forTypeName(typeName).build();
        }

        public static FieldType array(FieldType elementType) {
            return FieldType.forTypeName(TypeName.ARRAY).setCollectionElementType(elementType).build();
        }

        @Deprecated
        public static FieldType array(FieldType elementType, boolean nullable) {
            return FieldType.forTypeName(TypeName.ARRAY).setCollectionElementType(elementType.withNullable(nullable)).build();
        }

        public static FieldType iterable(FieldType elementType) {
            return FieldType.forTypeName(TypeName.ITERABLE).setCollectionElementType(elementType).build();
        }

        public static FieldType map(FieldType keyType, FieldType valueType) {
            return FieldType.forTypeName(TypeName.MAP).setMapKeyType(keyType).setMapValueType(valueType).build();
        }

        @Deprecated
        public static FieldType map(FieldType keyType, FieldType valueType, boolean valueTypeNullable) {
            return FieldType.forTypeName(TypeName.MAP).setMapKeyType(keyType).setMapValueType(valueType.withNullable(valueTypeNullable)).build();
        }

        public static FieldType row(Schema schema) {
            return FieldType.forTypeName(TypeName.ROW).setRowSchema(schema).build();
        }

        public static <InputT, BaseT> FieldType logicalType(LogicalType<InputT, BaseT> logicalType) {
            return FieldType.forTypeName(TypeName.LOGICAL_TYPE).setLogicalType(logicalType).build();
        }

        @Deprecated
        public FieldType withMetadata(Map<String, byte[]> metadata) {
            Map<String, ByteArrayWrapper> wrapped = metadata.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ByteArrayWrapper.wrap((byte[])e.getValue())));
            return this.toBuilder().setMetadata(wrapped).build();
        }

        @Deprecated
        public FieldType withMetadata(String key, byte[] metadata) {
            ImmutableMap<String, ByteArrayWrapper> newMetadata = ImmutableMap.builder().putAll(this.getMetadata()).put(key, ByteArrayWrapper.wrap(metadata)).build();
            return this.toBuilder().setMetadata(newMetadata).build();
        }

        @Deprecated
        public FieldType withMetadata(String key, String metadata) {
            return this.withMetadata(key, metadata.getBytes(StandardCharsets.UTF_8));
        }

        @Deprecated
        public Map<String, byte[]> getAllMetadata() {
            return this.getMetadata().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((ByteArrayWrapper)e.getValue()).array));
        }

        @Deprecated
        public byte @Nullable [] getMetadata(String key) {
            ByteArrayWrapper metadata = this.getMetadata().get(key);
            return metadata != null ? metadata.array : null;
        }

        @Deprecated
        public String getMetadataString(String key) {
            ByteArrayWrapper metadata = this.getMetadata().get(key);
            if (metadata != null) {
                return new String(metadata.array, StandardCharsets.UTF_8);
            }
            return "";
        }

        public FieldType withNullable(boolean nullable) {
            return this.toBuilder().setNullable(nullable).build();
        }

        public final boolean equals(@Nullable Object o) {
            if (!(o instanceof FieldType)) {
                return false;
            }
            FieldType other = (FieldType)o;
            if (this.getTypeName().isLogicalType()) {
                if (!other.getTypeName().isLogicalType()) {
                    return false;
                }
                if (!Objects.equals(this.getLogicalType().getIdentifier(), other.getLogicalType().getIdentifier())) {
                    return false;
                }
                if (this.getLogicalType().getArgument() == null) {
                    if (other.getLogicalType().getArgument() != null) {
                        return false;
                    }
                } else {
                    if (!this.getLogicalType().getArgumentType().equals(other.getLogicalType().getArgumentType())) {
                        return false;
                    }
                    if (!Row.Equals.deepEquals(this.getLogicalType().getArgument(), other.getLogicalType().getArgument(), this.getLogicalType().getArgumentType())) {
                        return false;
                    }
                }
            }
            return Objects.equals((Object)this.getTypeName(), (Object)other.getTypeName()) && Objects.equals(this.getNullable(), other.getNullable()) && Objects.equals(this.getCollectionElementType(), other.getCollectionElementType()) && Objects.equals(this.getMapKeyType(), other.getMapKeyType()) && Objects.equals(this.getMapValueType(), other.getMapValueType()) && Objects.equals(this.getRowSchema(), other.getRowSchema()) && Objects.equals(this.getMetadata(), other.getMetadata());
        }

        public boolean typesEqual(FieldType other) {
            if (!Objects.equals((Object)this.getTypeName(), (Object)other.getTypeName())) {
                return false;
            }
            if (this.getTypeName().isLogicalType()) {
                if (!other.getTypeName().isLogicalType()) {
                    return false;
                }
                if (!Objects.equals(this.getLogicalType().getIdentifier(), other.getLogicalType().getIdentifier())) {
                    return false;
                }
                if (!this.getLogicalType().getArgumentType().equals(other.getLogicalType().getArgumentType())) {
                    return false;
                }
                if (!Row.Equals.deepEquals(this.getLogicalType().getArgument(), other.getLogicalType().getArgument(), this.getLogicalType().getArgumentType())) {
                    return false;
                }
            }
            if (!Objects.equals(this.getNullable(), other.getNullable())) {
                return false;
            }
            if (!Objects.equals(this.getMetadata(), other.getMetadata())) {
                return false;
            }
            if (this.getTypeName().isCollectionType() && !this.getCollectionElementType().typesEqual(other.getCollectionElementType())) {
                return false;
            }
            if (!(this.getTypeName() != TypeName.MAP || this.getMapValueType().typesEqual(other.getMapValueType()) && this.getMapKeyType().typesEqual(other.getMapKeyType()))) {
                return false;
            }
            return this.getTypeName() != TypeName.ROW || this.getRowSchema().typesEqual(other.getRowSchema());
        }

        public boolean equivalent(FieldType other, EquivalenceNullablePolicy nullablePolicy) {
            if (nullablePolicy == EquivalenceNullablePolicy.SAME && !other.getNullable().equals(this.getNullable())) {
                return false;
            }
            if (nullablePolicy == EquivalenceNullablePolicy.WEAKEN && this.getNullable().booleanValue() && !other.getNullable().booleanValue()) {
                return false;
            }
            if (!this.getTypeName().equals((Object)other.getTypeName())) {
                return false;
            }
            switch (this.getTypeName()) {
                case ROW: {
                    if (this.getRowSchema().equivalent(other.getRowSchema(), nullablePolicy)) break;
                    return false;
                }
                case ARRAY: 
                case ITERABLE: {
                    if (this.getCollectionElementType().equivalent(other.getCollectionElementType(), nullablePolicy)) break;
                    return false;
                }
                case MAP: {
                    if (this.getMapKeyType().equivalent(other.getMapKeyType(), nullablePolicy) && this.getMapValueType().equivalent(other.getMapValueType(), nullablePolicy)) break;
                    return false;
                }
                default: {
                    return true;
                }
            }
            return true;
        }

        public final int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.getTypeName(), this.getNullable(), this.getCollectionElementType(), this.getMapKeyType(), this.getMapValueType(), this.getRowSchema(), this.getMetadata()});
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            switch (this.getTypeName()) {
                case ROW: {
                    builder.append("ROW<");
                    ImmutableList.Builder fieldEntries = ImmutableList.builder();
                    for (Field field : this.getRowSchema().getFields()) {
                        fieldEntries.add(field.getName() + " " + field.getType().toString());
                    }
                    builder.append(String.join((CharSequence)", ", fieldEntries.build()));
                    builder.append(">");
                    break;
                }
                case ARRAY: {
                    builder.append("ARRAY<");
                    builder.append(this.getCollectionElementType().toString());
                    builder.append(">");
                    break;
                }
                case MAP: {
                    builder.append("MAP<");
                    builder.append(this.getMapKeyType().toString());
                    builder.append(", ");
                    builder.append(this.getMapValueType().toString());
                    builder.append(">");
                    break;
                }
                default: {
                    builder.append(this.getTypeName().toString());
                }
            }
            if (!this.getNullable().booleanValue()) {
                builder.append(" NOT NULL");
            }
            return builder.toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setTypeName(TypeName var1);

            abstract Builder setLogicalType(LogicalType var1);

            abstract Builder setCollectionElementType(@Nullable FieldType var1);

            abstract Builder setNullable(Boolean var1);

            abstract Builder setMapKeyType(@Nullable FieldType var1);

            abstract Builder setMapValueType(@Nullable FieldType var1);

            abstract Builder setRowSchema(@Nullable Schema var1);

            @Deprecated
            abstract Builder setMetadata(Map<String, ByteArrayWrapper> var1);

            abstract FieldType build();
        }
    }

    public static interface LogicalType<InputT, BaseT>
    extends Serializable {
        public String getIdentifier();

        public @Nullable FieldType getArgumentType();

        default public <T> @Nullable T getArgument() {
            return null;
        }

        public FieldType getBaseType();

        public @NonNull BaseT toBaseType(@NonNull InputT var1);

        public @NonNull InputT toInputType(@NonNull BaseT var1);
    }

    public static enum TypeName {
        BYTE,
        INT16,
        INT32,
        INT64,
        DECIMAL,
        FLOAT,
        DOUBLE,
        STRING,
        DATETIME,
        BOOLEAN,
        BYTES,
        ARRAY,
        ITERABLE,
        MAP,
        ROW,
        LOGICAL_TYPE;

        public static final Set<TypeName> NUMERIC_TYPES;
        public static final Set<TypeName> STRING_TYPES;
        public static final Set<TypeName> DATE_TYPES;
        public static final Set<TypeName> COLLECTION_TYPES;
        public static final Set<TypeName> MAP_TYPES;
        public static final Set<TypeName> COMPOSITE_TYPES;

        public boolean isPrimitiveType() {
            return !this.isCollectionType() && !this.isMapType() && !this.isCompositeType() && !this.isLogicalType();
        }

        public boolean isNumericType() {
            return NUMERIC_TYPES.contains((Object)this);
        }

        public boolean isStringType() {
            return STRING_TYPES.contains((Object)this);
        }

        public boolean isDateType() {
            return DATE_TYPES.contains((Object)this);
        }

        public boolean isCollectionType() {
            return COLLECTION_TYPES.contains((Object)this);
        }

        public boolean isMapType() {
            return MAP_TYPES.contains((Object)this);
        }

        public boolean isCompositeType() {
            return COMPOSITE_TYPES.contains((Object)this);
        }

        public boolean isLogicalType() {
            return this.equals((Object)LOGICAL_TYPE);
        }

        public boolean isSubtypeOf(TypeName other) {
            return other.isSupertypeOf(this);
        }

        public boolean isSupertypeOf(TypeName other) {
            if (this == other) {
                return true;
            }
            if (!this.isNumericType() || !other.isNumericType()) {
                return false;
            }
            switch (this) {
                case BYTE: {
                    return false;
                }
                case INT16: {
                    return other == BYTE;
                }
                case INT32: {
                    return other == BYTE || other == INT16;
                }
                case INT64: {
                    return other == BYTE || other == INT16 || other == INT32;
                }
                case FLOAT: {
                    return false;
                }
                case DOUBLE: {
                    return other == FLOAT;
                }
                case DECIMAL: {
                    return other == FLOAT || other == DOUBLE;
                }
            }
            throw new AssertionError((Object)("Unexpected numeric type: " + (Object)((Object)this)));
        }

        static {
            NUMERIC_TYPES = ImmutableSet.of(BYTE, INT16, INT32, INT64, DECIMAL, FLOAT, new TypeName[]{DOUBLE});
            STRING_TYPES = ImmutableSet.of(STRING);
            DATE_TYPES = ImmutableSet.of(DATETIME);
            COLLECTION_TYPES = ImmutableSet.of(ARRAY, ITERABLE);
            MAP_TYPES = ImmutableSet.of(MAP);
            COMPOSITE_TYPES = ImmutableSet.of(ROW);
        }
    }

    public static enum EquivalenceNullablePolicy {
        SAME,
        WEAKEN,
        IGNORE;

    }

    public static class Builder {
        List<Field> fields;
        Options options = Options.none();

        public Builder() {
            this.fields = Lists.newArrayList();
        }

        public Builder addFields(List<Field> fields) {
            this.fields.addAll(fields);
            return this;
        }

        public Builder addFields(Field ... fields) {
            return this.addFields(Arrays.asList(fields));
        }

        public Builder addField(Field field) {
            this.fields.add(field);
            return this;
        }

        public Builder addField(String name, FieldType type) {
            this.fields.add(Field.of(name, type));
            return this;
        }

        public Builder addNullableField(String name, FieldType type) {
            this.fields.add(Field.nullable(name, type));
            return this;
        }

        public Builder addByteField(String name) {
            this.fields.add(Field.of(name, FieldType.BYTE));
            return this;
        }

        public Builder addByteArrayField(String name) {
            this.fields.add(Field.of(name, FieldType.BYTES));
            return this;
        }

        public Builder addInt16Field(String name) {
            this.fields.add(Field.of(name, FieldType.INT16));
            return this;
        }

        public Builder addInt32Field(String name) {
            this.fields.add(Field.of(name, FieldType.INT32));
            return this;
        }

        public Builder addInt64Field(String name) {
            this.fields.add(Field.of(name, FieldType.INT64));
            return this;
        }

        public Builder addDecimalField(String name) {
            this.fields.add(Field.of(name, FieldType.DECIMAL));
            return this;
        }

        public Builder addFloatField(String name) {
            this.fields.add(Field.of(name, FieldType.FLOAT));
            return this;
        }

        public Builder addDoubleField(String name) {
            this.fields.add(Field.of(name, FieldType.DOUBLE));
            return this;
        }

        public Builder addStringField(String name) {
            this.fields.add(Field.of(name, FieldType.STRING));
            return this;
        }

        public Builder addDateTimeField(String name) {
            this.fields.add(Field.of(name, FieldType.DATETIME));
            return this;
        }

        public Builder addBooleanField(String name) {
            this.fields.add(Field.of(name, FieldType.BOOLEAN));
            return this;
        }

        public <InputT, BaseT> Builder addLogicalTypeField(String name, LogicalType<InputT, BaseT> logicalType) {
            this.fields.add(Field.of(name, FieldType.logicalType(logicalType)));
            return this;
        }

        public Builder addArrayField(String name, FieldType collectionElementType) {
            this.fields.add(Field.of(name, FieldType.array(collectionElementType)));
            return this;
        }

        public Builder addIterableField(String name, FieldType collectionElementType) {
            this.fields.add(Field.of(name, FieldType.iterable(collectionElementType)));
            return this;
        }

        public Builder addRowField(String name, Schema fieldSchema) {
            this.fields.add(Field.of(name, FieldType.row(fieldSchema)));
            return this;
        }

        public Builder addMapField(String name, FieldType keyType, FieldType valueType) {
            this.fields.add(Field.of(name, FieldType.map(keyType, valueType)));
            return this;
        }

        public Builder setOptions(Options options) {
            this.options = options;
            return this;
        }

        public Builder setOptions(Options.Builder optionsBuilder) {
            this.options = optionsBuilder.build();
            return this;
        }

        public int getLastFieldId() {
            return this.fields.size() - 1;
        }

        public Schema build() {
            return new Schema(this.fields, this.options);
        }
    }

    static class ByteArrayWrapper
    implements Serializable {
        final byte[] array;

        private ByteArrayWrapper(byte[] array) {
            this.array = array;
        }

        static ByteArrayWrapper wrap(byte[] array) {
            return new ByteArrayWrapper(array);
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof ByteArrayWrapper)) {
                return false;
            }
            return Arrays.equals(this.array, ((ByteArrayWrapper)other).array);
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public String toString() {
            return Arrays.toString(this.array);
        }
    }
}

