/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class OneOfType
implements Schema.LogicalType<Value, Row> {
    public static final String IDENTIFIER = "OneOf";
    private final Schema oneOfSchema;
    private final EnumerationType enumerationType;
    private final byte[] schemaProtoRepresentation;

    private OneOfType(List<Schema.Field> fields) {
        this(fields, null);
    }

    private OneOfType(List<Schema.Field> fields, @Nullable Map<String, Integer> enumMap) {
        List<Schema.Field> nullableFields = fields.stream().map(f -> f.withNullable(true)).collect(Collectors.toList());
        if (enumMap != null) {
            nullableFields.stream().forEach(f -> Preconditions.checkArgument(enumMap.containsKey(f.getName())));
            this.enumerationType = EnumerationType.create(enumMap);
        } else {
            List<String> enumValues = nullableFields.stream().map(Schema.Field::getName).collect(Collectors.toList());
            this.enumerationType = EnumerationType.create(enumValues);
        }
        this.oneOfSchema = Schema.builder().addFields(nullableFields).build();
        this.schemaProtoRepresentation = SchemaTranslation.schemaToProto(this.oneOfSchema, false).toByteArray();
    }

    public static OneOfType create(Schema.Field ... fields) {
        return OneOfType.create(Arrays.asList(fields));
    }

    public static OneOfType create(List<Schema.Field> fields) {
        return new OneOfType(fields);
    }

    public static OneOfType create(List<Schema.Field> fields, Map<String, Integer> enumValues) {
        return new OneOfType(fields, enumValues);
    }

    public Schema getOneOfSchema() {
        return this.oneOfSchema;
    }

    public EnumerationType getCaseEnumType() {
        return this.enumerationType;
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Schema.FieldType getArgumentType() {
        return Schema.FieldType.BYTES;
    }

    @Override
    public byte[] getArgument() {
        return this.schemaProtoRepresentation;
    }

    @Override
    public Schema.FieldType getBaseType() {
        return Schema.FieldType.row(this.oneOfSchema);
    }

    public <T> Value createValue(String caseValue, T value) {
        return this.createValue(this.getCaseEnumType().valueOf(caseValue), value);
    }

    public <T> Value createValue(int caseValue, T value) {
        return this.createValue(this.getCaseEnumType().valueOf(caseValue), value);
    }

    public <T> Value createValue(EnumerationType.Value caseType, T value) {
        return new Value(caseType, value);
    }

    public Schema.FieldType getFieldType(Value oneOneValue) {
        return this.oneOfSchema.getField(this.enumerationType.toString(oneOneValue.getCaseType())).getType();
    }

    @Override
    public Row toBaseType(Value input) {
        EnumerationType.Value caseType = input.getCaseType();
        int setFieldIndex = this.oneOfSchema.indexOf(this.enumerationType.toString(caseType));
        Row.Builder builder = Row.withSchema(this.oneOfSchema);
        for (int i = 0; i < this.oneOfSchema.getFieldCount(); ++i) {
            Object value = i == setFieldIndex ? input.getValue() : null;
            builder = builder.addValue(value);
        }
        return builder.build();
    }

    @Override
    public Value toInputType(Row base) {
        EnumerationType.Value caseType = null;
        Object oneOfValue = null;
        for (int i = 0; i < base.getFieldCount(); ++i) {
            Object value = base.getValue(i);
            if (value == null) continue;
            Preconditions.checkArgument(caseType == null, "More than one field set in union " + this);
            caseType = this.enumerationType.valueOf(this.oneOfSchema.getField(i).getName());
            oneOfValue = value;
        }
        Preconditions.checkNotNull(oneOfValue, "No value set in union" + this);
        return this.createValue(caseType, oneOfValue);
    }

    public String toString() {
        return "OneOf: " + this.oneOfSchema;
    }

    public static class Value {
        private final EnumerationType.Value caseType;
        private final Object value;

        public Value(EnumerationType.Value caseType, Object value) {
            this.caseType = caseType;
            this.value = value;
        }

        public EnumerationType.Value getCaseType() {
            return this.caseType;
        }

        public <T> T getValue(Class<T> clazz) {
            return (T)this.value;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "caseType: " + this.caseType + " Value: " + this.value;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value1 = (Value)o;
            return Objects.equals(this.caseType, value1.caseType) && Objects.equals(this.value, value1.value);
        }

        public int hashCode() {
            return Objects.hash(this.caseType, this.value);
        }
    }
}

