/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.avro.specific.SpecificRecord;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.ByteBuddy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.asm.AsmVisitorWrapper;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.MethodCall;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

@Experimental(value=Experimental.Kind.SCHEMAS)
class AvroByteBuddyUtils {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy();
    private static final Map<ReflectUtils.ClassWithSchema, SchemaUserTypeCreator> CACHED_CREATORS = Maps.newConcurrentMap();

    AvroByteBuddyUtils() {
    }

    static <T extends SpecificRecord> SchemaUserTypeCreator getCreator(Class<T> clazz, Schema schema) {
        return CACHED_CREATORS.computeIfAbsent(ReflectUtils.ClassWithSchema.create(clazz, schema), c -> AvroByteBuddyUtils.createCreator(clazz, schema));
    }

    private static <T> SchemaUserTypeCreator createCreator(Class<T> clazz, Schema schema) {
        Constructor<?>[] constructors;
        Constructor<?> baseConstructor = null;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != schema.getFieldCount()) continue;
            baseConstructor = constructor;
        }
        if (baseConstructor == null) {
            throw new RuntimeException("No matching constructor found for class " + clazz);
        }
        MethodCall construct = MethodCall.construct(baseConstructor);
        for (int i = 0; i < baseConstructor.getParameterTypes().length; ++i) {
            Class<?> baseType = baseConstructor.getParameterTypes()[i];
            construct = construct.with(AvroByteBuddyUtils.readAndConvertParameter(baseType, i), baseType);
        }
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition<SchemaUserTypeCreator> builder = BYTE_BUDDY.with(new ByteBuddyUtils.InjectPackageStrategy(clazz)).subclass(SchemaUserTypeCreator.class).method(ElementMatchers.named("create")).intercept(construct);
            return (SchemaUserTypeCreator)builder.visit(new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(clazz.getClassLoader()), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a getter for class " + clazz + " with schema " + schema);
        }
    }

    private static StackManipulation readAndConvertParameter(Class<?> constructorParameterType, int index) {
        AvroUtils.AvroTypeConversionFactory typeConversionsFactory = new AvroUtils.AvroTypeConversionFactory();
        ByteBuddyUtils.TypeConversion<Type> convertType = typeConversionsFactory.createTypeConversion(true);
        TypeDescription.ForLoadedType convertedType = new TypeDescription.ForLoadedType((Class)convertType.convert(TypeDescriptor.of(constructorParameterType)));
        StackManipulation.Compound readParameter = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(1), IntegerConstant.forValue(index), ArrayAccess.REFERENCE.load(), TypeCasting.to(convertedType));
        return typeConversionsFactory.createSetterConversions(readParameter).convert(TypeDescriptor.of(constructorParameterType));
    }
}

