/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.state;

import java.util.Objects;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.OrderedListState;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.state.StateBinder;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.STATE)
public class StateSpecs {
    private static final CoderRegistry STANDARD_REGISTRY = CoderRegistry.createDefault();

    private StateSpecs() {
    }

    public static <T> StateSpec<ValueState<T>> value() {
        return new ValueStateSpec(null);
    }

    public static StateSpec<ValueState<Row>> rowValue(Schema schema) {
        return StateSpecs.value(RowCoder.of(schema));
    }

    public static <T> StateSpec<ValueState<T>> value(Coder<T> valueCoder) {
        Preconditions.checkArgument(valueCoder != null, "valueCoder should not be null. Consider value() instead");
        return new ValueStateSpec(valueCoder);
    }

    public static <InputT, AccumT, OutputT> StateSpec<CombiningState<InputT, AccumT, OutputT>> combining(Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        return new CombiningStateSpec(null, combineFn);
    }

    @Internal
    public static <InputT, AccumT, OutputT> StateSpec<CombiningState<InputT, AccumT, OutputT>> combining(CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
        return new CombiningWithContextStateSpec(null, combineFn);
    }

    public static <InputT, AccumT, OutputT> StateSpec<CombiningState<InputT, AccumT, OutputT>> combining(Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        Preconditions.checkArgument(accumCoder != null, "accumCoder should not be null. Consider using combining(CombineFn<> combineFn) instead.");
        return StateSpecs.combiningInternal(accumCoder, combineFn);
    }

    @Internal
    public static <InputT, AccumT, OutputT> StateSpec<CombiningState<InputT, AccumT, OutputT>> combining(Coder<AccumT> accumCoder, CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
        return StateSpecs.combiningInternal(accumCoder, combineFn);
    }

    public static <T> StateSpec<BagState<T>> bag() {
        return new BagStateSpec(null);
    }

    public static StateSpec<BagState<Row>> rowBag(Schema schema) {
        return new BagStateSpec<Row>(RowCoder.of(schema));
    }

    public static <T> StateSpec<BagState<T>> bag(Coder<T> elemCoder) {
        return new BagStateSpec(elemCoder);
    }

    public static <T> StateSpec<SetState<T>> set() {
        return new SetStateSpec(null);
    }

    public static StateSpec<SetState<Row>> rowSet(Schema schema) {
        return new SetStateSpec<Row>(RowCoder.of(schema));
    }

    public static <T> StateSpec<SetState<T>> set(Coder<T> elemCoder) {
        return new SetStateSpec(elemCoder);
    }

    public static <K, V> StateSpec<MapState<K, V>> map() {
        return new MapStateSpec(null, null);
    }

    public static StateSpec<MapState<Row, Row>> rowMap(Schema keySchema, Schema valueSchema) {
        return new MapStateSpec<Row, Row>(RowCoder.of(keySchema), RowCoder.of(valueSchema));
    }

    public static <K, V> StateSpec<MapState<K, V>> map(Coder<K> keyCoder, Coder<V> valueCoder) {
        return new MapStateSpec(keyCoder, valueCoder);
    }

    public static <T> StateSpec<OrderedListState<T>> orderedList(Coder<T> elemCoder) {
        return new OrderedListStateSpec(elemCoder);
    }

    public static StateSpec<OrderedListState<Row>> rowOrderedList(Schema valueSchema) {
        return new OrderedListStateSpec<Row>(RowCoder.of(valueSchema));
    }

    @Internal
    public static <InputT, AccumT, OutputT> StateSpec<CombiningState<InputT, AccumT, OutputT>> combiningFromInputInternal(Coder<InputT> inputCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        try {
            Coder accumCoder = combineFn.getAccumulatorCoder(STANDARD_REGISTRY, (Coder)inputCoder);
            return StateSpecs.combiningInternal(accumCoder, combineFn);
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalArgumentException("Unable to determine accumulator coder for " + combineFn.getClass().getSimpleName() + " from " + inputCoder, e);
        }
    }

    private static <InputT, AccumT, OutputT> StateSpec<CombiningState<InputT, AccumT, OutputT>> combiningInternal(Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        return new CombiningStateSpec(accumCoder, combineFn);
    }

    private static <InputT, AccumT, OutputT> StateSpec<CombiningState<InputT, AccumT, OutputT>> combiningInternal(Coder<AccumT> accumCoder, CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
        return new CombiningWithContextStateSpec(accumCoder, combineFn);
    }

    @Internal
    public static StateSpec<WatermarkHoldState> watermarkStateInternal(TimestampCombiner timestampCombiner) {
        return new WatermarkStateSpecInternal(timestampCombiner);
    }

    @Internal
    public static <InputT, AccumT, OutputT> StateSpec<BagState<AccumT>> convertToBagSpecInternal(StateSpec<CombiningState<InputT, AccumT, OutputT>> combiningSpec) {
        if (combiningSpec instanceof CombiningStateSpec) {
            CombiningStateSpec typedSpec = (CombiningStateSpec)combiningSpec;
            return typedSpec.asBagSpec();
        }
        if (combiningSpec instanceof CombiningWithContextStateSpec) {
            CombiningWithContextStateSpec typedSpec = (CombiningWithContextStateSpec)combiningSpec;
            return typedSpec.asBagSpec();
        }
        throw new IllegalArgumentException("Unexpected StateSpec " + combiningSpec);
    }

    @Internal
    public static <KeyT> StateSpec<MapState<KeyT, Boolean>> convertToMapSpecInternal(StateSpec<SetState<KeyT>> setStateSpec) {
        if (setStateSpec instanceof SetStateSpec) {
            SetStateSpec typedSpec = (SetStateSpec)setStateSpec;
            return typedSpec.asMapSpec();
        }
        throw new IllegalArgumentException("Unexpected StateSpec " + setStateSpec);
    }

    private static class WatermarkStateSpecInternal
    implements StateSpec<WatermarkHoldState> {
        private final TimestampCombiner timestampCombiner;

        private WatermarkStateSpecInternal(TimestampCombiner timestampCombiner) {
            this.timestampCombiner = timestampCombiner;
        }

        @Override
        public WatermarkHoldState bind(String id, StateBinder visitor) {
            return visitor.bindWatermark(id, this, this.timestampCombiner);
        }

        @Override
        public <ResultT> ResultT match(StateSpec.Cases<ResultT> cases) {
            throw new UnsupportedOperationException(String.format("%s is for internal use only and does not support case dispatch", this.getClass().getSimpleName()));
        }

        @Override
        public void offerCoders(Coder[] coders) {
        }

        @Override
        public void finishSpecifying() {
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof WatermarkStateSpecInternal;
        }

        public int hashCode() {
            return Objects.hash(this.getClass());
        }
    }

    private static class SetStateSpec<T>
    implements StateSpec<SetState<T>> {
        private @Nullable Coder<T> elemCoder;

        private SetStateSpec(@Nullable Coder<T> elemCoder) {
            this.elemCoder = elemCoder;
        }

        @Override
        public SetState<T> bind(String id, StateBinder visitor) {
            return visitor.bindSet(id, this, this.elemCoder);
        }

        @Override
        public <ResultT> ResultT match(StateSpec.Cases<ResultT> cases) {
            return cases.dispatchSet(this.elemCoder);
        }

        @Override
        public void offerCoders(Coder[] coders) {
            if (this.elemCoder == null && coders[0] != null) {
                this.elemCoder = coders[0];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.elemCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for SetState and no Coder was specified. Please set a coder by either invoking StateSpecs.set(Coder<T> elemCoder) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SetStateSpec)) {
                return false;
            }
            SetStateSpec that = (SetStateSpec)obj;
            return Objects.equals(this.elemCoder, that.elemCoder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.elemCoder);
        }

        private StateSpec<MapState<T, Boolean>> asMapSpec() {
            return new MapStateSpec(this.elemCoder, BooleanCoder.of());
        }
    }

    private static class MapStateSpec<K, V>
    implements StateSpec<MapState<K, V>> {
        private @Nullable Coder<K> keyCoder;
        private @Nullable Coder<V> valueCoder;

        private MapStateSpec(@Nullable Coder<K> keyCoder, @Nullable Coder<V> valueCoder) {
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
        }

        @Override
        public MapState<K, V> bind(String id, StateBinder visitor) {
            return visitor.bindMap(id, this, this.keyCoder, this.valueCoder);
        }

        @Override
        public <ResultT> ResultT match(StateSpec.Cases<ResultT> cases) {
            return cases.dispatchMap(this.keyCoder, this.valueCoder);
        }

        @Override
        public void offerCoders(Coder[] coders) {
            if (this.keyCoder == null && coders[0] != null) {
                this.keyCoder = coders[0];
            }
            if (this.valueCoder == null && coders[1] != null) {
                this.valueCoder = coders[1];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.keyCoder == null || this.valueCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for MapState and no Coder was specified. Please set a coder by either invoking StateSpecs.map(Coder<K> keyCoder, Coder<V> valueCoder) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MapStateSpec)) {
                return false;
            }
            MapStateSpec that = (MapStateSpec)obj;
            return Objects.equals(this.keyCoder, that.keyCoder) && Objects.equals(this.valueCoder, that.valueCoder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.keyCoder, this.valueCoder);
        }
    }

    private static class OrderedListStateSpec<T>
    implements StateSpec<OrderedListState<T>> {
        private @Nullable Coder<T> elemCoder;

        private OrderedListStateSpec(@Nullable Coder<T> elemCoder) {
            this.elemCoder = elemCoder;
        }

        @Override
        public OrderedListState<T> bind(String id, StateBinder visitor) {
            return visitor.bindOrderedList(id, this, this.elemCoder);
        }

        @Override
        public <ResultT> ResultT match(StateSpec.Cases<ResultT> cases) {
            return cases.dispatchOrderedList(this.elemCoder);
        }

        @Override
        public void offerCoders(Coder[] coders) {
            if (this.elemCoder == null && coders[0] != null) {
                this.elemCoder = coders[0];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.elemCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for OrderedListState and no Coder was specified. Please set a coder by either invoking StateSpecs.orderedListState(Coder<K> elemCoder), specifying a schema,  or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof OrderedListStateSpec)) {
                return false;
            }
            OrderedListStateSpec that = (OrderedListStateSpec)obj;
            return Objects.equals(this.elemCoder, that.elemCoder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.elemCoder);
        }
    }

    private static class BagStateSpec<T>
    implements StateSpec<BagState<T>> {
        private @Nullable Coder<T> elemCoder;

        private BagStateSpec(@Nullable Coder<T> elemCoder) {
            this.elemCoder = elemCoder;
        }

        @Override
        public BagState<T> bind(String id, StateBinder visitor) {
            return visitor.bindBag(id, this, this.elemCoder);
        }

        @Override
        public <ResultT> ResultT match(StateSpec.Cases<ResultT> cases) {
            return cases.dispatchBag(this.elemCoder);
        }

        @Override
        public void offerCoders(Coder[] coders) {
            if (this.elemCoder == null && coders[0] != null) {
                this.elemCoder = coders[0];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.elemCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for BagState and no Coder was specified. Please set a coder by either invoking StateSpecs.bag(Coder<T> elemCoder) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BagStateSpec)) {
                return false;
            }
            BagStateSpec that = (BagStateSpec)obj;
            return Objects.equals(this.elemCoder, that.elemCoder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.elemCoder);
        }
    }

    private static class CombiningWithContextStateSpec<InputT, AccumT, OutputT>
    implements StateSpec<CombiningState<InputT, AccumT, OutputT>> {
        private @Nullable Coder<AccumT> accumCoder;
        private final CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn;

        private CombiningWithContextStateSpec(@Nullable Coder<AccumT> accumCoder, CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
            this.combineFn = combineFn;
            this.accumCoder = accumCoder;
        }

        @Override
        public CombiningState<InputT, AccumT, OutputT> bind(String id, StateBinder visitor) {
            return visitor.bindCombiningWithContext(id, this, this.accumCoder, this.combineFn);
        }

        @Override
        public <ResultT> ResultT match(StateSpec.Cases<ResultT> cases) {
            throw new UnsupportedOperationException(String.format("%s is for internal use only and does not support case dispatch", this.getClass().getSimpleName()));
        }

        @Override
        public void offerCoders(Coder[] coders) {
            if (this.accumCoder == null && coders[2] != null) {
                this.accumCoder = coders[2];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.accumCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for CombiningWithContextState and no Coder was specified. Please set a coder by either invoking StateSpecs.combiningWithcontext(Coder<AccumT> accumCoder, CombineFnWithContext<InputT, AccumT, OutputT> combineFn) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CombiningWithContextStateSpec)) {
                return false;
            }
            CombiningWithContextStateSpec that = (CombiningWithContextStateSpec)obj;
            return Objects.equals(this.accumCoder, that.accumCoder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.accumCoder);
        }

        private StateSpec<BagState<AccumT>> asBagSpec() {
            return new BagStateSpec(this.accumCoder);
        }
    }

    private static class CombiningStateSpec<InputT, AccumT, OutputT>
    implements StateSpec<CombiningState<InputT, AccumT, OutputT>> {
        private @Nullable Coder<AccumT> accumCoder;
        private final Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

        private CombiningStateSpec(@Nullable Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            this.combineFn = combineFn;
            this.accumCoder = accumCoder;
        }

        @Override
        public CombiningState<InputT, AccumT, OutputT> bind(String id, StateBinder visitor) {
            return visitor.bindCombining(id, this, this.accumCoder, this.combineFn);
        }

        @Override
        public <ResultT> ResultT match(StateSpec.Cases<ResultT> cases) {
            return cases.dispatchCombining(this.combineFn, this.accumCoder);
        }

        @Override
        public void offerCoders(Coder[] coders) {
            if (this.accumCoder == null && coders[1] != null) {
                this.accumCoder = coders[1];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.accumCoder == null) {
                throw new IllegalStateException("Unable to infer a coder for CombiningState and no Coder was specified. Please set a coder by either invoking StateSpecs.combining(Coder<AccumT> accumCoder, CombineFn<InputT, AccumT, OutputT> combineFn) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CombiningStateSpec)) {
                return false;
            }
            CombiningStateSpec that = (CombiningStateSpec)obj;
            return Objects.equals(this.accumCoder, that.accumCoder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.accumCoder);
        }

        private StateSpec<BagState<AccumT>> asBagSpec() {
            return new BagStateSpec(this.accumCoder);
        }
    }

    private static class ValueStateSpec<T>
    implements StateSpec<ValueState<T>> {
        private @Nullable Coder<T> coder;

        private ValueStateSpec(@Nullable Coder<T> coder) {
            this.coder = coder;
        }

        @Override
        public ValueState<T> bind(String id, StateBinder visitor) {
            return visitor.bindValue(id, this, this.coder);
        }

        @Override
        public <ResultT> ResultT match(StateSpec.Cases<ResultT> cases) {
            return cases.dispatchValue(this.coder);
        }

        @Override
        public void offerCoders(Coder[] coders) {
            if (this.coder == null && coders[0] != null) {
                this.coder = coders[0];
            }
        }

        @Override
        public void finishSpecifying() {
            if (this.coder == null) {
                throw new IllegalStateException("Unable to infer a coder for ValueState and no Coder was specified. Please set a coder by either invoking StateSpecs.value(Coder<T> valueCoder) or by registering the coder in the Pipeline's CoderRegistry.");
            }
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ValueStateSpec)) {
                return false;
            }
            ValueStateSpec that = (ValueStateSpec)obj;
            return Objects.equals(this.coder, that.coder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.coder);
        }
    }
}

