/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;

public class SerializableMatchers
implements Serializable {
    private SerializableMatchers() {
    }

    public static <T> SerializableMatcher<T> allOf(Iterable<SerializableMatcher<? super T>> serializableMatchers) {
        Iterable matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.allOf(matchers));
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T> allOf(SerializableMatcher<T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.allOf(matchers));
    }

    public static <T> SerializableMatcher<T> anyOf(Iterable<SerializableMatcher<? super T>> serializableMatchers) {
        Iterable matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.anyOf(matchers));
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T> anyOf(SerializableMatcher<T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.anyOf(matchers));
    }

    public static SerializableMatcher<Object> anything() {
        return SerializableMatchers.fromSupplier(Matchers::anything);
    }

    @SafeVarargs
    public static <T extends Serializable> SerializableMatcher<T[]> arrayContaining(T ... items) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContaining(items));
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T[]> arrayContaining(Coder<T> coder, T ... items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContaining((Object[])itemsSupplier.get()));
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T[]> arrayContaining(SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContaining(matchers));
    }

    public static <T> SerializableMatcher<T[]> arrayContaining(List<SerializableMatcher<? super T>> serializableMatchers) {
        List matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContaining(matchers));
    }

    @SafeVarargs
    public static <T extends Serializable> SerializableMatcher<T[]> arrayContainingInAnyOrder(T ... items) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContainingInAnyOrder(items));
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T[]> arrayContainingInAnyOrder(Coder<T> coder, T ... items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContaining((Object[])itemsSupplier.get()));
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T[]> arrayContainingInAnyOrder(SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContainingInAnyOrder(matchers));
    }

    public static <T> SerializableMatcher<T[]> arrayContainingInAnyOrder(Collection<SerializableMatcher<? super T>> serializableMatchers) {
        Collection matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayContainingInAnyOrder(matchers));
    }

    public static <T> SerializableMatcher<T[]> arrayWithSize(int size) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayWithSize(size));
    }

    public static <T> SerializableMatcher<T[]> arrayWithSize(SerializableMatcher<? super Integer> sizeMatcher) {
        return SerializableMatchers.fromSupplier(() -> Matchers.arrayWithSize(sizeMatcher));
    }

    public static SerializableMatcher<Double> closeTo(double target, double error) {
        return SerializableMatchers.fromSupplier(() -> Matchers.closeTo(target, error));
    }

    @SafeVarargs
    public static <T extends Serializable> SerializableMatcher<Iterable<? extends T>> contains(T ... items) {
        return SerializableMatchers.fromSupplier(() -> Matchers.contains(items));
    }

    @SafeVarargs
    public static <T> SerializableMatcher<Iterable<? extends T>> contains(Coder<T> coder, T ... items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Matchers.containsInAnyOrder((Object[])itemsSupplier.get()));
    }

    @SafeVarargs
    public static <T> SerializableMatcher<Iterable<? extends T>> contains(SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.contains(matchers));
    }

    public static <T extends Serializable> SerializableMatcher<Iterable<? extends T>> contains(List<SerializableMatcher<? super T>> serializableMatchers) {
        List matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.contains(matchers));
    }

    @SafeVarargs
    public static <T extends Serializable> SerializableMatcher<Iterable<? extends T>> containsInAnyOrder(T ... items) {
        return SerializableMatchers.fromSupplier(() -> Matchers.containsInAnyOrder(items));
    }

    @SafeVarargs
    public static <T> SerializableMatcher<Iterable<? extends T>> containsInAnyOrder(Coder<T> coder, T ... items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Matchers.containsInAnyOrder((Object[])itemsSupplier.get()));
    }

    @SafeVarargs
    public static <T> SerializableMatcher<Iterable<? extends T>> containsInAnyOrder(SerializableMatcher<? super T> ... matchers) {
        return SerializableMatchers.fromSupplier(() -> Matchers.containsInAnyOrder(matchers));
    }

    public static <T> SerializableMatcher<Iterable<? extends T>> containsInAnyOrder(Collection<SerializableMatcher<? super T>> serializableMatchers) {
        Collection matchers = serializableMatchers;
        return SerializableMatchers.fromSupplier(() -> Matchers.containsInAnyOrder(matchers));
    }

    public static SerializableMatcher<String> containsString(String substring) {
        return SerializableMatchers.fromSupplier(() -> Matchers.containsString(substring));
    }

    public static <T> SerializableMatcher<Collection<? extends T>> empty() {
        return SerializableMatchers.fromSupplier(Matchers::empty);
    }

    public static <T> SerializableMatcher<T[]> emptyArray() {
        return SerializableMatchers.fromSupplier(Matchers::emptyArray);
    }

    public static <T> SerializableMatcher<Iterable<? extends T>> emptyIterable() {
        return SerializableMatchers.fromSupplier(Matchers::emptyIterable);
    }

    public static SerializableMatcher<String> endsWith(String substring) {
        return SerializableMatchers.fromSupplier(() -> Matchers.endsWith(substring));
    }

    public static <T extends Serializable> SerializableMatcher<T> equalTo(T expected) {
        return SerializableMatchers.fromSupplier(() -> Matchers.equalTo(expected));
    }

    public static <T> SerializableMatcher<T> equalTo(Coder<T> coder, T expected) {
        SerializableViaCoder expectedSupplier = new SerializableViaCoder(coder, expected);
        return SerializableMatchers.fromSupplier(() -> Matchers.equalTo(expectedSupplier.get()));
    }

    public static <T extends Comparable<T> & Serializable> SerializableMatcher<T> greaterThan(T target) {
        return SerializableMatchers.fromSupplier(() -> Matchers.greaterThan(target));
    }

    public static <T extends Comparable<T> & Serializable> SerializableMatcher<T> greaterThan(Coder<T> coder, T target) {
        SerializableViaCoder targetSupplier = new SerializableViaCoder(coder, target);
        return SerializableMatchers.fromSupplier(() -> Matchers.greaterThan((Comparable)targetSupplier.get()));
    }

    public static <T extends Comparable<T>> SerializableMatcher<T> greaterThanOrEqualTo(T target) {
        return SerializableMatchers.fromSupplier(() -> Matchers.greaterThanOrEqualTo(target));
    }

    public static <T extends Comparable<T> & Serializable> SerializableMatcher<T> greaterThanOrEqualTo(Coder<T> coder, T target) {
        SerializableViaCoder targetSupplier = new SerializableViaCoder(coder, target);
        return SerializableMatchers.fromSupplier(() -> Matchers.greaterThanOrEqualTo((Comparable)targetSupplier.get()));
    }

    public static <T extends Serializable> SerializableMatcher<Iterable<? super T>> hasItem(T target) {
        return SerializableMatchers.fromSupplier(() -> Matchers.hasItem(target));
    }

    public static <T> SerializableMatcher<Iterable<? super T>> hasItem(Coder<T> coder, T target) {
        SerializableViaCoder targetSupplier = new SerializableViaCoder(coder, target);
        return SerializableMatchers.fromSupplier(() -> Matchers.hasItem(targetSupplier.get()));
    }

    public static <T> SerializableMatcher<Iterable<? super T>> hasItem(SerializableMatcher<? super T> matcher) {
        return SerializableMatchers.fromSupplier(() -> Matchers.hasItem(matcher));
    }

    public static <T> SerializableMatcher<Collection<? extends T>> hasSize(int size) {
        return SerializableMatchers.fromSupplier(() -> Matchers.hasSize(size));
    }

    public static <T> SerializableMatcher<Collection<? extends T>> hasSize(SerializableMatcher<? super Integer> sizeMatcher) {
        return SerializableMatchers.fromSupplier(() -> Matchers.hasSize(sizeMatcher));
    }

    public static <T> SerializableMatcher<Iterable<T>> iterableWithSize(int size) {
        return SerializableMatchers.fromSupplier(() -> Matchers.iterableWithSize(size));
    }

    public static <T> SerializableMatcher<Iterable<T>> iterableWithSize(SerializableMatcher<? super Integer> sizeMatcher) {
        return SerializableMatchers.fromSupplier(() -> Matchers.iterableWithSize(sizeMatcher));
    }

    public static <T extends Serializable> SerializableMatcher<T> isIn(Collection<T> collection) {
        return SerializableMatchers.fromSupplier(() -> Is.is(Matchers.in(collection)));
    }

    public static <T> SerializableMatcher<T> isIn(Coder<T> coder, Collection<T> collection) {
        Object[] items = collection.toArray();
        SerializableArrayViaCoder<Object> itemsSupplier = new SerializableArrayViaCoder<Object>(coder, items);
        return SerializableMatchers.fromSupplier(() -> Is.is(Matchers.in((Object[])itemsSupplier.get())));
    }

    public static <T extends Serializable> SerializableMatcher<T> isIn(T[] items) {
        return SerializableMatchers.fromSupplier(() -> Is.is(Matchers.in(items)));
    }

    public static <T> SerializableMatcher<T> isIn(Coder<T> coder, T[] items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Is.is(Matchers.in((Object[])itemsSupplier.get())));
    }

    @SafeVarargs
    public static <T extends Serializable> SerializableMatcher<T> isOneOf(T ... elems) {
        return SerializableMatchers.fromSupplier(() -> Matchers.isOneOf(elems));
    }

    @SafeVarargs
    public static <T> SerializableMatcher<T> isOneOf(Coder<T> coder, T ... items) {
        SerializableArrayViaCoder itemsSupplier = new SerializableArrayViaCoder(coder, items);
        return SerializableMatchers.fromSupplier(() -> Matchers.isOneOf((Object[])itemsSupplier.get()));
    }

    public static <K extends Serializable, V> SerializableMatcher<KV<? extends K, ? extends V>> kvWithKey(K key) {
        return new KvKeyMatcher(SerializableMatchers.equalTo(key));
    }

    public static <K, V> SerializableMatcher<KV<? extends K, ? extends V>> kvWithKey(Coder<K> coder, K key) {
        return new KvKeyMatcher(SerializableMatchers.equalTo(coder, key));
    }

    public static <K, V> SerializableMatcher<KV<? extends K, ? extends V>> kvWithKey(SerializableMatcher<? super K> keyMatcher) {
        return new KvKeyMatcher(keyMatcher);
    }

    public static <K, V extends Serializable> SerializableMatcher<KV<? extends K, ? extends V>> kvWithValue(V value) {
        return new KvValueMatcher(SerializableMatchers.equalTo(value));
    }

    public static <K, V> SerializableMatcher<KV<? extends K, ? extends V>> kvWithValue(Coder<V> coder, V value) {
        return new KvValueMatcher(SerializableMatchers.equalTo(coder, value));
    }

    public static <K, V> SerializableMatcher<KV<? extends K, ? extends V>> kvWithValue(SerializableMatcher<? super V> valueMatcher) {
        return new KvValueMatcher(valueMatcher);
    }

    public static <K, V> SerializableMatcher<KV<? extends K, ? extends V>> kv(SerializableMatcher<? super K> keyMatcher, SerializableMatcher<? super V> valueMatcher) {
        return SerializableMatchers.allOf(SerializableMatchers.kvWithKey(keyMatcher), SerializableMatchers.kvWithValue(valueMatcher));
    }

    public static <T extends Comparable<T> & Serializable> SerializableMatcher<T> lessThan(T target) {
        return SerializableMatchers.fromSupplier(() -> Matchers.lessThan(target));
    }

    public static <T extends Comparable<T>> SerializableMatcher<T> lessThan(Coder<T> coder, T target) {
        SerializableViaCoder targetSupplier = new SerializableViaCoder(coder, target);
        return SerializableMatchers.fromSupplier(() -> Matchers.lessThan((Comparable)targetSupplier.get()));
    }

    public static <T extends Comparable<T> & Serializable> SerializableMatcher<T> lessThanOrEqualTo(T target) {
        return SerializableMatchers.fromSupplier(() -> Matchers.lessThanOrEqualTo(target));
    }

    public static <T extends Comparable<T>> SerializableMatcher<T> lessThanOrEqualTo(Coder<T> coder, T target) {
        SerializableViaCoder targetSupplier = new SerializableViaCoder(coder, target);
        return SerializableMatchers.fromSupplier(() -> Matchers.lessThanOrEqualTo((Comparable)targetSupplier.get()));
    }

    public static <T> SerializableMatcher<T> not(SerializableMatcher<T> matcher) {
        return SerializableMatchers.fromSupplier(() -> Matchers.not(matcher));
    }

    public static SerializableMatcher<Object> nullValue() {
        return SerializableMatchers.fromSupplier(Matchers::nullValue);
    }

    public static SerializableMatcher<String> startsWith(String substring) {
        return SerializableMatchers.fromSupplier(() -> Matchers.startsWith(substring));
    }

    public static <T> SerializableMatcher<T> fromSupplier(SerializableSupplier<Matcher<T>> supplier) {
        return new SerializableMatcherFromSupplier<T>(supplier);
    }

    private static class SerializableArrayViaCoder<T>
    implements SerializableSupplier<T[]> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
        private transient T @Nullable [] value;
        private byte[] encodedValue;
        private Coder<List<T>> coder;

        public SerializableArrayViaCoder(Coder<T> elementCoder, T[] value) {
            this.coder = ListCoder.of(elementCoder);
            this.value = value;
            try {
                this.encodedValue = CoderUtils.encodeToByteArray(this.coder, Arrays.asList(value));
            }
            catch (CoderException exc) {
                throw UserCodeException.wrap(exc);
            }
        }

        @Override
        public T[] get() {
            if (this.value == null) {
                try {
                    Object[] decoded = CoderUtils.decodeFromByteArray(this.coder, this.encodedValue).toArray();
                    this.value = decoded;
                }
                catch (CoderException exc) {
                    throw new RuntimeException("Error deserializing via Coder", exc);
                }
            }
            return this.value;
        }
    }

    private static class SerializableViaCoder<T>
    implements SerializableSupplier<T> {
        private transient @Nullable T value;
        private byte[] encodedValue;
        private Coder<T> coder;

        public SerializableViaCoder(Coder<T> coder, T value) {
            this.coder = coder;
            this.value = value;
            try {
                this.encodedValue = CoderUtils.encodeToByteArray(coder, value);
            }
            catch (CoderException exc) {
                throw new RuntimeException("Error serializing via Coder", exc);
            }
        }

        @Override
        public T get() {
            if (this.value == null) {
                try {
                    this.value = CoderUtils.decodeFromByteArray(this.coder, this.encodedValue);
                }
                catch (CoderException exc) {
                    throw new RuntimeException("Error deserializing via Coder", exc);
                }
            }
            return this.value;
        }
    }

    private static class SerializableMatcherFromSupplier<T>
    extends BaseMatcher<T>
    implements SerializableMatcher<T> {
        private SerializableSupplier<Matcher<T>> supplier;

        public SerializableMatcherFromSupplier(SerializableSupplier<Matcher<T>> supplier) {
            this.supplier = supplier;
        }

        @Override
        public void describeTo(Description description) {
            this.supplier.get().describeTo(description);
        }

        @Override
        public boolean matches(Object item) {
            return this.supplier.get().matches(item);
        }

        @Override
        public void describeMismatch(Object item, Description mismatchDescription) {
            this.supplier.get().describeMismatch(item, mismatchDescription);
        }
    }

    public static interface SerializableSupplier<T>
    extends Serializable {
        public T get();
    }

    private static class KvValueMatcher<K, V>
    extends BaseMatcher<KV<? extends K, ? extends V>>
    implements SerializableMatcher<KV<? extends K, ? extends V>> {
        private final SerializableMatcher<? super V> valueMatcher;

        public KvValueMatcher(SerializableMatcher<? super V> valueMatcher) {
            this.valueMatcher = valueMatcher;
        }

        @Override
        public boolean matches(Object item) {
            KV kvItem = (KV)item;
            return this.valueMatcher.matches(kvItem.getValue());
        }

        @Override
        public void describeMismatch(Object item, Description mismatchDescription) {
            KV kvItem = (KV)item;
            if (!this.valueMatcher.matches(kvItem.getValue())) {
                mismatchDescription.appendText("value did not match: ");
                this.valueMatcher.describeMismatch(kvItem.getValue(), mismatchDescription);
            }
        }

        @Override
        public void describeTo(Description description) {
            description.appendText("KV with value matching ");
            this.valueMatcher.describeTo(description);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).addValue(this.valueMatcher).toString();
        }
    }

    private static class KvKeyMatcher<K, V>
    extends BaseMatcher<KV<? extends K, ? extends V>>
    implements SerializableMatcher<KV<? extends K, ? extends V>> {
        private final SerializableMatcher<? super K> keyMatcher;

        public KvKeyMatcher(SerializableMatcher<? super K> keyMatcher) {
            this.keyMatcher = keyMatcher;
        }

        @Override
        public boolean matches(Object item) {
            KV kvItem = (KV)item;
            return this.keyMatcher.matches(kvItem.getKey());
        }

        @Override
        public void describeMismatch(Object item, Description mismatchDescription) {
            KV kvItem = (KV)item;
            if (!this.keyMatcher.matches(kvItem.getKey())) {
                mismatchDescription.appendText("key did not match: ");
                this.keyMatcher.describeMismatch(kvItem.getKey(), mismatchDescription);
            }
        }

        @Override
        public void describeTo(Description description) {
            description.appendText("KV with key matching ");
            this.keyMatcher.describeTo(description);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).addValue(this.keyMatcher).toString();
        }
    }
}

