/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.WeightedValue;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ApproximateQuantiles {
    private ApproximateQuantiles() {
    }

    public static <T, ComparatorT extends Comparator<T> & Serializable> PTransform<PCollection<T>, PCollection<List<T>>> globally(int numQuantiles, ComparatorT compareFn) {
        return Combine.globally(ApproximateQuantilesCombineFn.create(numQuantiles, compareFn));
    }

    public static <T extends Comparable<T>> PTransform<PCollection<T>, PCollection<List<T>>> globally(int numQuantiles) {
        return Combine.globally(ApproximateQuantilesCombineFn.create(numQuantiles));
    }

    public static <K, V, ComparatorT extends Comparator<V> & Serializable> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, List<V>>>> perKey(int numQuantiles, ComparatorT compareFn) {
        return Combine.perKey(ApproximateQuantilesCombineFn.create(numQuantiles, compareFn));
    }

    public static <K, V extends Comparable<V>> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, List<V>>>> perKey(int numQuantiles) {
        return Combine.perKey(ApproximateQuantilesCombineFn.create(numQuantiles));
    }

    private static class QuantileStateCoder<T, ComparatorT extends Comparator<T> & Serializable>
    extends CustomCoder<QuantileState<T, ComparatorT>> {
        private final ComparatorT compareFn;
        private final Coder<T> elementCoder;
        private final Coder<List<T>> elementListCoder;
        private final Coder<Integer> intCoder = BigEndianIntegerCoder.of();

        public QuantileStateCoder(ComparatorT compareFn, Coder<T> elementCoder) {
            this.compareFn = compareFn;
            this.elementCoder = elementCoder;
            this.elementListCoder = ListCoder.of(elementCoder);
        }

        @Override
        public void encode(QuantileState<T, ComparatorT> state, OutputStream outStream) throws CoderException, IOException {
            this.intCoder.encode(((QuantileState)state).numQuantiles, outStream);
            this.intCoder.encode(((QuantileState)state).bufferSize, outStream);
            this.elementCoder.encode(((QuantileState)state).min, outStream);
            this.elementCoder.encode(((QuantileState)state).max, outStream);
            this.elementListCoder.encode(((QuantileState)state).unbufferedElements, outStream);
            BigEndianIntegerCoder.of().encode(((QuantileState)state).buffers.size(), outStream);
            for (QuantileBuffer buffer : ((QuantileState)state).buffers) {
                this.encodeBuffer(buffer, outStream);
            }
        }

        @Override
        public QuantileState<T, ComparatorT> decode(InputStream inStream) throws CoderException, IOException {
            int numQuantiles = this.intCoder.decode(inStream);
            int bufferSize = this.intCoder.decode(inStream);
            T min2 = this.elementCoder.decode(inStream);
            T max = this.elementCoder.decode(inStream);
            List<T> unbufferedElements = this.elementListCoder.decode(inStream);
            int numBuffers = BigEndianIntegerCoder.of().decode(inStream);
            ArrayList<QuantileBuffer<T>> buffers = new ArrayList<QuantileBuffer<T>>(numBuffers);
            for (int i = 0; i < numBuffers; ++i) {
                buffers.add(this.decodeBuffer(inStream));
            }
            return new QuantileState((Comparator)this.compareFn, numQuantiles, min2, max, numBuffers, bufferSize, unbufferedElements, buffers, null);
        }

        private void encodeBuffer(QuantileBuffer<T> buffer, OutputStream outStream) throws CoderException, IOException {
            DataOutputStream outData = new DataOutputStream(outStream);
            outData.writeInt(((QuantileBuffer)buffer).level);
            outData.writeLong(((QuantileBuffer)buffer).weight);
            this.elementListCoder.encode(((QuantileBuffer)buffer).elements, outStream);
        }

        private QuantileBuffer<T> decodeBuffer(InputStream inStream) throws IOException, CoderException {
            DataInputStream inData = new DataInputStream(inStream);
            return new QuantileBuffer<T>(inData.readInt(), inData.readLong(), this.elementListCoder.decode(inStream));
        }

        @Override
        public void registerByteSizeObserver(QuantileState<T, ComparatorT> state, ElementByteSizeObserver observer) throws Exception {
            this.elementCoder.registerByteSizeObserver(((QuantileState)state).min, observer);
            this.elementCoder.registerByteSizeObserver(((QuantileState)state).max, observer);
            this.elementListCoder.registerByteSizeObserver(((QuantileState)state).unbufferedElements, observer);
            BigEndianIntegerCoder.of().registerByteSizeObserver(((QuantileState)state).buffers.size(), observer);
            for (QuantileBuffer buffer : ((QuantileState)state).buffers) {
                observer.update(12L);
                this.elementListCoder.registerByteSizeObserver(buffer.elements, observer);
            }
        }

        public boolean equals(@Nullable Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof QuantileStateCoder)) {
                return false;
            }
            QuantileStateCoder that = (QuantileStateCoder)other;
            return Objects.equals(this.elementCoder, that.elementCoder) && Objects.equals(this.compareFn, that.compareFn);
        }

        public int hashCode() {
            return Objects.hash(this.elementCoder, this.compareFn);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            QuantileStateCoder.verifyDeterministic(this, "QuantileState.ElementCoder must be deterministic", this.elementCoder);
            QuantileStateCoder.verifyDeterministic(this, "QuantileState.ElementListCoder must be deterministic", this.elementListCoder);
        }
    }

    private static class QuantileBuffer<T> {
        private int level;
        private long weight;
        private List<T> elements;

        public QuantileBuffer(List<T> elements) {
            this(0, 1L, elements);
        }

        public QuantileBuffer(int level, long weight, List<T> elements) {
            this.level = level;
            this.weight = weight;
            this.elements = elements;
        }

        public String toString() {
            return "QuantileBuffer[level=" + this.level + ", weight=" + this.weight + ", elements=" + this.elements + "]";
        }

        public Iterator<WeightedValue<T>> sizedIterator() {
            return new UnmodifiableIterator<WeightedValue<T>>(){
                Iterator<T> iter;
                {
                    this.iter = elements.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public WeightedValue<T> next() {
                    return WeightedValue.of(this.iter.next(), weight);
                }
            };
        }
    }

    static class QuantileState<T, ComparatorT extends Comparator<T> & Serializable>
    implements Combine.AccumulatingCombineFn.Accumulator<T, QuantileState<T, ComparatorT>, List<T>> {
        private ComparatorT compareFn;
        private int numQuantiles;
        private int numBuffers;
        private int bufferSize;
        private @Nullable T min;
        private @Nullable T max;
        private PriorityQueue<QuantileBuffer<T>> buffers;
        private List<T> unbufferedElements = Lists.newArrayList();
        private int offsetJitter = 0;

        private QuantileState(ComparatorT compareFn, int numQuantiles, @Nullable T min2, @Nullable T max, int numBuffers, int bufferSize, Collection<T> unbufferedElements, Collection<QuantileBuffer<T>> buffers) {
            this.compareFn = compareFn;
            this.numQuantiles = numQuantiles;
            this.numBuffers = numBuffers;
            this.bufferSize = bufferSize;
            this.buffers = new PriorityQueue(numBuffers + 1, (q1, q2) -> Integer.compare(((QuantileBuffer)q1).level, ((QuantileBuffer)q2).level));
            this.min = min2;
            this.max = max;
            this.unbufferedElements.addAll(unbufferedElements);
            this.buffers.addAll(buffers);
        }

        public static <T, ComparatorT extends Comparator<T> & Serializable> QuantileState<T, ComparatorT> empty(ComparatorT compareFn, int numQuantiles, int numBuffers, int bufferSize) {
            return new QuantileState<Object, ComparatorT>(compareFn, numQuantiles, null, null, numBuffers, bufferSize, Collections.emptyList(), Collections.emptyList());
        }

        public static <T, ComparatorT extends Comparator<T> & Serializable> QuantileState<T, ComparatorT> singleton(ComparatorT compareFn, int numQuantiles, T elem, int numBuffers, int bufferSize) {
            return new QuantileState<T, ComparatorT>(compareFn, numQuantiles, elem, elem, numBuffers, bufferSize, Collections.singletonList(elem), Collections.emptyList());
        }

        @Override
        public void addInput(T elem) {
            if (this.isEmpty()) {
                this.max = elem;
                this.min = this.max;
            } else if (this.compareFn.compare(elem, this.min) < 0) {
                this.min = elem;
            } else if (this.compareFn.compare(elem, this.max) > 0) {
                this.max = elem;
            }
            this.addUnbuffered(elem);
        }

        private void addUnbuffered(T elem) {
            this.unbufferedElements.add(elem);
            if (this.unbufferedElements.size() == this.bufferSize) {
                this.unbufferedElements.sort((Comparator<T>)this.compareFn);
                this.buffers.add(new QuantileBuffer<T>(this.unbufferedElements));
                this.unbufferedElements = Lists.newArrayListWithCapacity(this.bufferSize);
                this.collapseIfNeeded();
            }
        }

        @Override
        public void mergeAccumulator(QuantileState<T, ComparatorT> other) {
            if (other.isEmpty()) {
                return;
            }
            if (this.min == null || this.compareFn.compare(other.min, this.min) < 0) {
                this.min = other.min;
            }
            if (this.max == null || this.compareFn.compare(other.max, this.max) > 0) {
                this.max = other.max;
            }
            for (T elem : other.unbufferedElements) {
                this.addUnbuffered(elem);
            }
            this.buffers.addAll(other.buffers);
            this.collapseIfNeeded();
        }

        public boolean isEmpty() {
            return this.unbufferedElements.isEmpty() && this.buffers.isEmpty();
        }

        private void collapseIfNeeded() {
            while (this.buffers.size() > this.numBuffers) {
                ArrayList<QuantileBuffer<T>> toCollapse = Lists.newArrayList();
                toCollapse.add(this.buffers.poll());
                toCollapse.add(this.buffers.poll());
                int minLevel = ((QuantileBuffer)toCollapse.get(1)).level;
                while (!this.buffers.isEmpty() && ((QuantileBuffer)this.buffers.peek()).level == minLevel) {
                    toCollapse.add(this.buffers.poll());
                }
                this.buffers.add(this.collapse(toCollapse));
            }
        }

        private QuantileBuffer<T> collapse(Iterable<QuantileBuffer<T>> buffers) {
            int newLevel = 0;
            long newWeight = 0L;
            for (QuantileBuffer<T> buffer : buffers) {
                newLevel = Math.max(newLevel, ((QuantileBuffer)buffer).level + 1);
                newWeight += ((QuantileBuffer)buffer).weight;
            }
            List<T> newElements = this.interpolate(buffers, this.bufferSize, newWeight, this.offset(newWeight));
            return new QuantileBuffer<T>(newLevel, newWeight, newElements);
        }

        private long offset(long newWeight) {
            if (newWeight % 2L == 1L) {
                return (newWeight + 1L) / 2L;
            }
            this.offsetJitter = 2 - this.offsetJitter;
            return (newWeight + (long)this.offsetJitter) / 2L;
        }

        private List<T> interpolate(Iterable<QuantileBuffer<T>> buffers, int count, double step, double offset) {
            ArrayList<Iterator<WeightedValue<T>>> iterators = Lists.newArrayList();
            for (QuantileBuffer<T> buffer : buffers) {
                iterators.add(buffer.sizedIterator());
            }
            UnmodifiableIterator sorted = Iterators.mergeSorted(iterators, (a, b) -> this.compareFn.compare(a.getValue(), b.getValue()));
            ArrayList newElements = Lists.newArrayListWithCapacity(count);
            WeightedValue weightedElement = (WeightedValue)sorted.next();
            double current = weightedElement.getWeight();
            for (int j = 0; j < count; ++j) {
                double target = (double)j * step + offset;
                while (current <= target && sorted.hasNext()) {
                    weightedElement = (WeightedValue)sorted.next();
                    current += (double)weightedElement.getWeight();
                }
                newElements.add(weightedElement.getValue());
            }
            return newElements;
        }

        @Override
        public List<T> extractOutput() {
            if (this.isEmpty()) {
                return Lists.newArrayList();
            }
            long totalCount = this.unbufferedElements.size();
            for (QuantileBuffer<T> buffer : this.buffers) {
                totalCount += (long)this.bufferSize * ((QuantileBuffer)buffer).weight;
            }
            ArrayList<QuantileBuffer<T>> all = Lists.newArrayList(this.buffers);
            if (!this.unbufferedElements.isEmpty()) {
                this.unbufferedElements.sort((Comparator<T>)this.compareFn);
                all.add(new QuantileBuffer<T>(this.unbufferedElements));
            }
            double step = 1.0 * (double)totalCount / (double)(this.numQuantiles - 1);
            double offset = (1.0 * (double)totalCount - 1.0) / (double)(this.numQuantiles - 1);
            List<T> quantiles = this.interpolate(all, this.numQuantiles - 2, step, offset);
            quantiles.add(0, this.min);
            quantiles.add(this.max);
            return quantiles;
        }

        /* synthetic */ QuantileState(Comparator x0, int x1, Object x2, Object x3, int x4, int x5, Collection x6, Collection x7, 1 x8) {
            this(x0, x1, x2, x3, x4, x5, x6, x7);
        }
    }

    public static class ApproximateQuantilesCombineFn<T, ComparatorT extends Comparator<T> & Serializable>
    extends Combine.AccumulatingCombineFn<T, QuantileState<T, ComparatorT>, List<T>> {
        public static final long DEFAULT_MAX_NUM_ELEMENTS = 1000000000L;
        private final ComparatorT compareFn;
        private final int numQuantiles;
        private final int bufferSize;
        private final int numBuffers;
        private final long maxNumElements;

        private ApproximateQuantilesCombineFn(int numQuantiles, ComparatorT compareFn, int bufferSize, int numBuffers, long maxNumElements) {
            Preconditions.checkArgument(numQuantiles >= 2);
            Preconditions.checkArgument(bufferSize >= 2);
            Preconditions.checkArgument(numBuffers >= 2);
            this.numQuantiles = numQuantiles;
            this.compareFn = compareFn;
            this.bufferSize = bufferSize;
            this.numBuffers = numBuffers;
            this.maxNumElements = maxNumElements;
        }

        public static <T, ComparatorT extends Comparator<T> & Serializable> ApproximateQuantilesCombineFn<T, ComparatorT> create(int numQuantiles, ComparatorT compareFn) {
            return ApproximateQuantilesCombineFn.create(numQuantiles, compareFn, 1000000000L, 1.0 / (double)numQuantiles);
        }

        public static <T extends Comparable<T>> ApproximateQuantilesCombineFn<T, Top.Natural<T>> create(int numQuantiles) {
            return ApproximateQuantilesCombineFn.create(numQuantiles, new Top.Natural());
        }

        public ApproximateQuantilesCombineFn<T, ComparatorT> withEpsilon(double epsilon) {
            return ApproximateQuantilesCombineFn.create(this.numQuantiles, this.compareFn, this.maxNumElements, epsilon);
        }

        public ApproximateQuantilesCombineFn<T, ComparatorT> withMaxInputSize(long maxNumElements) {
            return ApproximateQuantilesCombineFn.create(this.numQuantiles, this.compareFn, maxNumElements, maxNumElements);
        }

        public static <T, ComparatorT extends Comparator<T> & Serializable> ApproximateQuantilesCombineFn<T, ComparatorT> create(int numQuantiles, ComparatorT compareFn, long maxNumElements, double epsilon) {
            int b = 2;
            while ((double)((b - 2) * (1 << b - 2)) < epsilon * (double)maxNumElements) {
                ++b;
            }
            int k = Math.max(2, (int)Math.ceil((float)maxNumElements / (float)(1 << --b - 1)));
            return new ApproximateQuantilesCombineFn<T, ComparatorT>(numQuantiles, compareFn, k, b, maxNumElements);
        }

        @Override
        public QuantileState<T, ComparatorT> createAccumulator() {
            return QuantileState.empty(this.compareFn, this.numQuantiles, this.numBuffers, this.bufferSize);
        }

        @Override
        public Coder<QuantileState<T, ComparatorT>> getAccumulatorCoder(CoderRegistry registry, Coder<T> elementCoder) {
            return new QuantileStateCoder<T, ComparatorT>(this.compareFn, elementCoder);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("numQuantiles", this.numQuantiles).withLabel("Quantile Count")).add(DisplayData.item("comparer", this.compareFn.getClass()).withLabel("Record Comparer"));
        }

        int getNumBuffers() {
            return this.numBuffers;
        }

        int getBufferSize() {
            return this.bufferSize;
        }
    }
}

