/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;

@Experimental(value=Experimental.Kind.CONTEXTFUL)
public final class Contextful<ClosureT>
implements Serializable {
    private final ClosureT closure;
    private final Requirements requirements;

    private Contextful(ClosureT closure, Requirements requirements) {
        this.closure = closure;
        this.requirements = requirements;
    }

    public ClosureT getClosure() {
        return this.closure;
    }

    public Requirements getRequirements() {
        return this.requirements;
    }

    public static <ClosureT> Contextful<ClosureT> of(ClosureT closure, Requirements requirements) {
        return new Contextful<ClosureT>(closure, requirements);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("closure", this.closure).add("requirements", this.requirements).toString();
    }

    public static <InputT, OutputT> Contextful<Fn<InputT, OutputT>> fn(ProcessFunction<InputT, OutputT> fn) {
        return new Contextful<Fn<InputT, OutputT>>((element, c) -> fn.apply(element), Requirements.empty());
    }

    public static <InputT, OutputT> Contextful<Fn<InputT, OutputT>> fn(SerializableFunction<InputT, OutputT> fn) {
        return Contextful.fn(fn);
    }

    public static <InputT, OutputT> Contextful<Fn<InputT, OutputT>> fn(Fn<InputT, OutputT> fn, Requirements requirements) {
        return Contextful.of(fn, requirements);
    }

    public static interface Fn<InputT, OutputT>
    extends Serializable {
        public OutputT apply(InputT var1, Context var2) throws Exception;

        public static abstract class Context {
            public <T> T sideInput(PCollectionView<T> view) {
                throw new UnsupportedOperationException();
            }

            public static <InputT> Context wrapProcessContext(DoFn.ProcessContext c) {
                return new ContextFromProcessContext(c);
            }

            private static class ContextFromProcessContext<InputT>
            extends Context {
                private final DoFn.ProcessContext c;

                ContextFromProcessContext(DoFn.ProcessContext c) {
                    this.c = c;
                }

                @Override
                public <T> T sideInput(PCollectionView<T> view) {
                    return this.c.sideInput(view);
                }
            }
        }
    }
}

