/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Iterator;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class Latest {
    private Latest() {
    }

    public static <T> Combine.CombineFn<TimestampedValue<T>, ?, T> combineFn() {
        return new LatestFn();
    }

    public static <T> PTransform<PCollection<T>, PCollection<T>> globally() {
        return new Globally();
    }

    public static <K, V> PTransform<PCollection<KV<K, V>>, PCollection<KV<K, V>>> perKey() {
        return new PerKey();
    }

    private static class PerKey<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, V>>> {
        private PerKey() {
        }

        @Override
        public PCollection<KV<K, V>> expand(PCollection<KV<K, V>> input) {
            Preconditions.checkNotNull(input);
            Preconditions.checkArgument(input.getCoder() instanceof KvCoder, "Input specifiedCoder must be an instance of KvCoder, but was %s", input.getCoder());
            KvCoder inputCoder = (KvCoder)input.getCoder();
            return ((PCollection)input.apply("Reify Timestamps", Reify.timestampsInValue()).apply("Latest Value", Combine.perKey(new LatestFn()))).setCoder(inputCoder);
        }
    }

    private static class Globally<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private Globally() {
        }

        @Override
        public PCollection<T> expand(PCollection<T> input) {
            Coder<T> inputCoder = input.getCoder();
            return ((PCollection)input.apply("Reify Timestamps", Reify.timestamps()).apply("Latest Value", Combine.globally(new LatestFn()))).setCoder(NullableCoder.of(inputCoder));
        }
    }

    @VisibleForTesting
    static class LatestFn<T>
    extends Combine.CombineFn<TimestampedValue<T>, TimestampedValue<T>, T> {
        @Override
        public TimestampedValue<T> createAccumulator() {
            return TimestampedValue.atMinimumTimestamp(null);
        }

        @Override
        public TimestampedValue<T> addInput(TimestampedValue<T> accumulator, TimestampedValue<T> input) {
            Preconditions.checkNotNull(accumulator, "accumulator must be non-null");
            Preconditions.checkNotNull(input, "input must be non-null");
            if (input.getTimestamp().isBefore(accumulator.getTimestamp())) {
                return accumulator;
            }
            return input;
        }

        @Override
        public Coder<TimestampedValue<T>> getAccumulatorCoder(CoderRegistry registry, Coder<TimestampedValue<T>> inputCoder) throws CannotProvideCoderException {
            return NullableCoder.of(inputCoder);
        }

        @Override
        public Coder<T> getDefaultOutputCoder(CoderRegistry registry, Coder<TimestampedValue<T>> inputCoder) throws CannotProvideCoderException {
            Preconditions.checkState(inputCoder instanceof TimestampedValue.TimestampedValueCoder, "inputCoder must be a TimestampedValueCoder, but was %s", inputCoder);
            TimestampedValue.TimestampedValueCoder inputTVCoder = (TimestampedValue.TimestampedValueCoder)inputCoder;
            return NullableCoder.of(inputTVCoder.getValueCoder());
        }

        @Override
        public TimestampedValue<T> mergeAccumulators(Iterable<TimestampedValue<T>> accumulators) {
            Preconditions.checkNotNull(accumulators, "accumulators must be non-null");
            Iterator<TimestampedValue<T>> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            TimestampedValue<T> merged = iter.next();
            while (iter.hasNext()) {
                merged = this.addInput(merged, iter.next());
            }
            return merged;
        }

        @Override
        public T extractOutput(TimestampedValue<T> accumulator) {
            return accumulator.getValue();
        }
    }
}

