/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.Materialization;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@Internal
public class Materializations {
    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static final String ITERABLE_MATERIALIZATION_URN = "beam:side_input:iterable:v1";
    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static final String MULTIMAP_MATERIALIZATION_URN = "beam:side_input:multimap:v1";

    @Internal
    public static <K, V> Materialization<MultimapView<K, V>> multimap() {
        return new Materialization<MultimapView<K, V>>(){

            @Override
            public String getUrn() {
                return Materializations.MULTIMAP_MATERIALIZATION_URN;
            }
        };
    }

    @Internal
    public static <V> Materialization<IterableView<V>> iterable() {
        return new Materialization<IterableView<V>>(){

            @Override
            public String getUrn() {
                return Materializations.ITERABLE_MATERIALIZATION_URN;
            }
        };
    }

    static {
        Preconditions.checkState(ITERABLE_MATERIALIZATION_URN.equals(RunnerApi.StandardSideInputTypes.Enum.ITERABLE.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn)), "Expected %s to match proto constant but found %s.", (Object)ITERABLE_MATERIALIZATION_URN, (Object)RunnerApi.StandardSideInputTypes.Enum.ITERABLE.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn));
        Preconditions.checkState(MULTIMAP_MATERIALIZATION_URN.equals(RunnerApi.StandardSideInputTypes.Enum.MULTIMAP.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn)), "Expected %s to match proto constant but found %s.", (Object)MULTIMAP_MATERIALIZATION_URN, (Object)RunnerApi.StandardSideInputTypes.Enum.MULTIMAP.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn));
    }

    public static interface MultimapView<K, V> {
        public Iterable<K> get();

        public Iterable<V> get(@Nullable K var1);
    }

    public static interface IterableView<V> {
        public Iterable<V> get();
    }
}

