/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.PeriodicSequence;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class PeriodicImpulse
extends PTransform<PBegin, PCollection<Instant>> {
    Instant startTimestamp = Instant.now();
    Instant stopTimestamp = BoundedWindow.TIMESTAMP_MAX_VALUE;
    Duration fireInterval = Duration.standardMinutes(1L);
    boolean applyWindowing = false;

    private PeriodicImpulse() {
    }

    public static PeriodicImpulse create() {
        return new PeriodicImpulse();
    }

    public PeriodicImpulse startAt(Instant startTime) {
        this.startTimestamp = startTime;
        return this;
    }

    public PeriodicImpulse stopAt(Instant stopTime) {
        this.stopTimestamp = stopTime;
        return this;
    }

    public PeriodicImpulse withInterval(Duration interval) {
        this.fireInterval = interval;
        return this;
    }

    public PeriodicImpulse applyWindowing() {
        this.applyWindowing = true;
        return this;
    }

    @Override
    public PCollection<Instant> expand(PBegin input) {
        PCollection result = ((PCollection)input.apply(Create.of(new PeriodicSequence.SequenceDefinition(this.startTimestamp, this.stopTimestamp, this.fireInterval), new PeriodicSequence.SequenceDefinition[0]))).apply(PeriodicSequence.create());
        if (this.applyWindowing) {
            result = (PCollection)result.apply(Window.into(FixedWindows.of(Duration.millis(this.fireInterval.getMillis()))));
        }
        return result;
    }
}

