/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.resourcehints;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHint;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHintsOptions;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Charsets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResourceHints {
    private static final String MIN_RAM_URN = "beam:resources:min_ram_bytes:v1";
    private static final String ACCELERATOR_URN = "beam:resources:accelerator:v1";
    private static ImmutableMap<String, String> hintNameToUrn;
    private static ImmutableMap<String, Function<String, ResourceHint>> parsers;
    private static final ResourceHints EMPTY;
    private final ImmutableMap<String, ResourceHint> hints;

    private static String getUrn(ProtocolMessageEnum value) {
        return value.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);
    }

    private ResourceHints(ImmutableMap<String, ResourceHint> hints) {
        this.hints = hints;
    }

    public static ResourceHints create() {
        return EMPTY;
    }

    public static ResourceHints fromOptions(PipelineOptions options) {
        ResourceHintsOptions resourceHintsOptions = options.as(ResourceHintsOptions.class);
        ResourceHints result = ResourceHints.create();
        List<String> hints = resourceHintsOptions.getResourceHints();
        Splitter splitter = Splitter.on('=').limit(2);
        for (String hint : hints) {
            String urn;
            List<String> parts = splitter.splitToList(hint);
            if (parts.size() != 2) {
                throw new IllegalArgumentException("Unparsable resource hint: " + hint);
            }
            String nameOrUrn = parts.get(0);
            String stringValue = parts.get(1);
            if (hintNameToUrn.containsKey(nameOrUrn)) {
                urn = hintNameToUrn.get(nameOrUrn);
            } else {
                if (!nameOrUrn.startsWith("beam:resources:")) {
                    throw new IllegalArgumentException("Unknown resource hint: " + hint);
                }
                urn = nameOrUrn;
            }
            ResourceHint value = parsers.getOrDefault(urn, s2 -> new StringHint((String)s2)).apply(stringValue);
            result = result.withHint(urn, value);
        }
        return result;
    }

    public ResourceHints withMinRam(long ramBytes) {
        return this.withHint(MIN_RAM_URN, new BytesHint(ramBytes));
    }

    public ResourceHints withMinRam(String ramBytes) {
        return this.withMinRam(BytesHint.parse(ramBytes));
    }

    public ResourceHints withAccelerator(String accelerator) {
        return this.withHint(ACCELERATOR_URN, new StringHint(accelerator));
    }

    public ResourceHints withHint(String urn, ResourceHint hint) {
        ImmutableMap.Builder<String, ResourceHint> newHints = ImmutableMap.builder();
        newHints.put(urn, hint);
        for (Map.Entry oldHint : this.hints.entrySet()) {
            if (((String)oldHint.getKey()).equals(urn)) continue;
            newHints.put((String)oldHint.getKey(), (ResourceHint)oldHint.getValue());
        }
        return new ResourceHints(newHints.build());
    }

    public Map<String, ResourceHint> hints() {
        return this.hints;
    }

    public ResourceHints mergeWithOuter(ResourceHints outer) {
        if (outer.hints.isEmpty()) {
            return this;
        }
        if (this.hints.isEmpty()) {
            return outer;
        }
        ImmutableMap.Builder<String, ResourceHint> newHints = ImmutableMap.builder();
        for (Map.Entry<String, ResourceHint> outerHint : outer.hints().entrySet()) {
            if (this.hints.containsKey(outerHint.getKey())) {
                newHints.put(outerHint.getKey(), this.hints.get(outerHint.getKey()).mergeWithOuter(outerHint.getValue()));
                continue;
            }
            newHints.put(outerHint);
        }
        for (Map.Entry hint : this.hints.entrySet()) {
            if (outer.hints.containsKey(hint.getKey())) continue;
            newHints.put(hint);
        }
        return new ResourceHints(newHints.build());
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof ResourceHints) {
            return ((ResourceHints)other).hints.equals(this.hints);
        }
        return false;
    }

    public int hashCode() {
        return this.hints.hashCode();
    }

    static {
        Preconditions.checkState(MIN_RAM_URN.equals(ResourceHints.getUrn(RunnerApi.StandardResourceHints.Enum.MIN_RAM_BYTES)));
        Preconditions.checkState(ACCELERATOR_URN.equals(ResourceHints.getUrn(RunnerApi.StandardResourceHints.Enum.ACCELERATOR)));
        hintNameToUrn = ImmutableMap.builder().put("minRam", MIN_RAM_URN).put("min_ram", MIN_RAM_URN).put("accelerator", ACCELERATOR_URN).build();
        parsers = ImmutableMap.builder().put(MIN_RAM_URN, s2 -> new BytesHint(BytesHint.parse(s2))).put(ACCELERATOR_URN, s2 -> new StringHint((String)s2)).build();
        EMPTY = new ResourceHints(ImmutableMap.of());
    }

    static class StringHint
    extends ResourceHint {
        private final String value;

        public StringHint(String value) {
            this.value = value;
        }

        public static String parse(String s2) {
            return s2;
        }

        @Override
        public byte[] toBytes() {
            return this.value.getBytes(Charsets.US_ASCII);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof StringHint) {
                return ((StringHint)other).value.equals(this.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }
    }

    static class BytesHint
    extends ResourceHint {
        private static Map<String, Long> suffixes = ImmutableMap.builder().put("B", 1L).put("KB", 1000L).put("MB", 1000000L).put("GB", 1000000000L).put("TB", 1000000000000L).put("PB", 1000000000000000L).put("KiB", 1024L).put("MiB", 0x100000L).put("GiB", 0x40000000L).put("TiB", 0x10000000000L).put("PiB", 0x4000000000000L).build();
        private final long value;

        @Override
        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof BytesHint) {
                return ((BytesHint)other).value == this.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.value);
        }

        public BytesHint(long value) {
            this.value = value;
        }

        public static long parse(String s2) {
            Matcher m3 = Pattern.compile("([\\d.]+)[\\s]?([\\D]+$)").matcher(s2);
            if (m3.find()) {
                String number = m3.group(1);
                String suffix = m3.group(2);
                if (number != null && suffix != null && suffixes.containsKey(suffix)) {
                    return (long)(Double.valueOf(number) * (double)suffixes.get(suffix).longValue());
                }
            }
            throw new IllegalArgumentException("Unable to parse '" + s2 + "' as a byte value.");
        }

        @Override
        public ResourceHint mergeWithOuter(ResourceHint outer) {
            return new BytesHint(Math.max(this.value, ((BytesHint)outer).value));
        }

        @Override
        public byte[] toBytes() {
            return String.valueOf(this.value).getBytes(Charsets.US_ASCII);
        }
    }
}

