/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.TimestampObservingWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Instant;

public class WatermarkEstimators {
    private WatermarkEstimators() {
    }

    public static class MonotonicallyIncreasing
    implements TimestampObservingWatermarkEstimator<Instant> {
        private Instant watermark;
        private Instant lastObservedTimestamp;

        public MonotonicallyIncreasing(Instant watermark) {
            BoundedWindow.validateTimestampBounds(watermark);
            this.watermark = Preconditions.checkNotNull(watermark, "timestamp must not be null.");
        }

        @Override
        public void observeTimestamp(Instant timestamp) {
            this.lastObservedTimestamp = timestamp;
        }

        @Override
        public Instant currentWatermark() {
            if (this.lastObservedTimestamp != null && this.lastObservedTimestamp.isAfter(this.watermark)) {
                this.watermark = this.lastObservedTimestamp;
            }
            return this.watermark;
        }

        @Override
        public Instant getState() {
            return this.watermark;
        }
    }

    public static class WallTime
    implements WatermarkEstimator<Instant> {
        private Instant watermark;

        public WallTime(Instant watermark) {
            BoundedWindow.validateTimestampBounds(watermark);
            this.watermark = Preconditions.checkNotNull(watermark, "watermark must not be null.");
        }

        @Override
        public Instant currentWatermark() {
            Instant now = Instant.now();
            this.watermark = now.isAfter(this.watermark) ? now : this.watermark;
            return this.watermark;
        }

        @Override
        public Instant getState() {
            return this.watermark;
        }
    }

    public static class Manual
    implements ManualWatermarkEstimator<Instant> {
        private Instant watermark;
        private Instant lastReportedWatermark;

        public Manual(Instant watermark) {
            BoundedWindow.validateTimestampBounds(watermark);
            this.watermark = Preconditions.checkNotNull(watermark, "watermark must not be null.");
        }

        @Override
        public void setWatermark(Instant watermark) {
            BoundedWindow.validateTimestampBounds(watermark);
            this.lastReportedWatermark = watermark;
        }

        @Override
        public Instant currentWatermark() {
            if (this.lastReportedWatermark != null && this.lastReportedWatermark.isAfter(this.watermark)) {
                this.watermark = this.lastReportedWatermark;
            }
            return this.watermark;
        }

        @Override
        public Instant getState() {
            return this.watermark;
        }
    }
}

