/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterEach
extends Trigger {
    private AfterEach(List<Trigger> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    @SafeVarargs
    public static AfterEach inOrder(Trigger ... triggers) {
        return new AfterEach(Arrays.asList(triggers));
    }

    public static AfterEach inOrder(List<Trigger> triggers) {
        return new AfterEach(triggers);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(BoundedWindow window) {
        return ((Trigger)this.subTriggers.get(0)).getWatermarkThatGuaranteesFiring(window);
    }

    @Override
    public boolean mayFinish() {
        return this.subTriggers.stream().allMatch(trigger -> trigger.mayFinish());
    }

    @Override
    protected Trigger getContinuationTrigger(List<Trigger> continuationTriggers) {
        return Repeatedly.forever(new AfterFirst(continuationTriggers));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterEach.inOrder(");
        Joiner.on(", ").appendTo(builder, (Iterable<?>)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }
}

