/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.joda.time.Instant;

public class OrFinallyTrigger
extends Trigger {
    private static final int ACTUAL = 0;
    private static final int UNTIL = 1;

    @VisibleForTesting
    OrFinallyTrigger(Trigger actual, Trigger.OnceTrigger until) {
        super(Arrays.asList(actual, until));
    }

    public Trigger getMainTrigger() {
        return this.subTriggers().get(0);
    }

    public Trigger.OnceTrigger getUntilTrigger() {
        return (Trigger.OnceTrigger)this.subTriggers().get(1);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(BoundedWindow window) {
        Instant untilDeadline;
        Instant actualDeadline = ((Trigger)this.subTriggers.get(0)).getWatermarkThatGuaranteesFiring(window);
        return actualDeadline.isBefore(untilDeadline = ((Trigger)this.subTriggers.get(1)).getWatermarkThatGuaranteesFiring(window)) ? actualDeadline : untilDeadline;
    }

    @Override
    public boolean mayFinish() {
        return ((Trigger)this.subTriggers.get(0)).mayFinish() || ((Trigger)this.subTriggers.get(1)).mayFinish();
    }

    @Override
    protected Trigger getContinuationTrigger(List<Trigger> continuationTriggers) {
        return Repeatedly.forever(new OrFinallyTrigger(continuationTriggers.get(0), (Trigger.OnceTrigger)continuationTriggers.get(1)));
    }

    @Override
    public String toString() {
        return String.format("%s.orFinally(%s)", this.subTriggers.get(0), this.subTriggers.get(1));
    }
}

