/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.TaggedPValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PCollectionList<T>
implements PInput,
POutput {
    final Pipeline pipeline;
    final List<TaggedPValue> pcollections;

    public static <T> PCollectionList<T> empty(Pipeline pipeline) {
        return new PCollectionList<T>(pipeline);
    }

    public static <T> PCollectionList<T> of(PCollection<T> pc) {
        return new PCollectionList<T>(pc.getPipeline()).and(pc);
    }

    public static <T> PCollectionList<T> of(Iterable<PCollection<T>> pcs) {
        Iterator<PCollection<T>> pcsIter = pcs.iterator();
        if (!pcsIter.hasNext()) {
            throw new IllegalArgumentException("must either have a non-empty list of PCollections, or must first call empty(Pipeline)");
        }
        return new PCollectionList<T>(pcsIter.next().getPipeline()).and(pcs);
    }

    public PCollectionList<T> and(PCollection<T> pc) {
        if (pc.getPipeline() != this.pipeline) {
            throw new IllegalArgumentException("PCollections come from different Pipelines");
        }
        return new PCollectionList<T>(this.pipeline, (List<TaggedPValue>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.pcollections)).add(TaggedPValue.of(new TupleTag(Integer.toString(this.pcollections.size())), pc))).build()));
    }

    public PCollectionList<T> and(Iterable<PCollection<T>> pcs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.pcollections);
        int nextIndex = this.pcollections.size();
        for (PCollection<T> pc : pcs) {
            if (pc.getPipeline() != this.pipeline) {
                throw new IllegalArgumentException("PCollections come from different Pipelines");
            }
            builder.add(TaggedPValue.of(new TupleTag(Integer.toString(nextIndex)), pc));
            ++nextIndex;
        }
        return new PCollectionList<T>(this.pipeline, (List<TaggedPValue>)((Object)builder.build()));
    }

    public int size() {
        return this.pcollections.size();
    }

    public PCollection<T> get(int index) {
        PCollection<?> value = this.pcollections.get(index).getValue();
        return value;
    }

    public List<PCollection<T>> getAll() {
        ImmutableList.Builder res = ImmutableList.builder();
        for (TaggedPValue value : this.pcollections) {
            PCollection<?> typedValue = value.getValue();
            res.add(typedValue);
        }
        return res.build();
    }

    public <OutputT extends POutput> OutputT apply(PTransform<PCollectionList<T>, OutputT> t) {
        return Pipeline.applyTransform(this, t);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<PCollectionList<T>, OutputT> t) {
        return Pipeline.applyTransform(name, this, t);
    }

    PCollectionList(Pipeline pipeline) {
        this(pipeline, ImmutableList.of());
    }

    PCollectionList(Pipeline pipeline, List<TaggedPValue> values) {
        this.pipeline = pipeline;
        this.pcollections = ImmutableList.copyOf(values);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public Map<TupleTag<?>, PValue> expand() {
        ImmutableMap.Builder<TupleTag<?>, PCollection<?>> expanded = ImmutableMap.builder();
        for (TaggedPValue tagged : this.pcollections) {
            expanded.put(tagged.getTag(), tagged.getValue());
        }
        return expanded.build();
    }

    @Override
    public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
        int i = 0;
        for (TaggedPValue tpv : this.pcollections) {
            PCollection<?> pc = tpv.getValue();
            if (pc.getName().equals(PValueBase.defaultName(transformName))) {
                pc.setName(String.format("%s.%s%s", transformName, "out", i));
            }
            ++i;
        }
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof PCollectionList)) {
            return false;
        }
        PCollectionList that = (PCollectionList)other;
        return this.pipeline.equals(that.pipeline) && this.getAll().equals(that.getAll());
    }

    public int hashCode() {
        return Objects.hash(this.pipeline, this.getAll());
    }
}

