/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@Internal
public abstract class PValueBase
implements PValue {
    private final transient @Nullable Pipeline pipeline;
    private @Nullable String name;
    private boolean finishedSpecifying = false;

    @Override
    public String getName() {
        if (this.name == null) {
            throw new IllegalStateException("name not set");
        }
        return this.name;
    }

    public PValueBase setName(String name) {
        Preconditions.checkState(!this.finishedSpecifying, "cannot change the name of %s once it's been used", (Object)this);
        this.name = name;
        return this;
    }

    protected PValueBase(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    protected PValueBase() {
        this.pipeline = null;
    }

    boolean isFinishedSpecifying() {
        return this.finishedSpecifying;
    }

    @Override
    public void finishSpecifying(PInput input, PTransform<?, ?> transform) {
        this.finishedSpecifying = true;
    }

    public String toString() {
        return (this.name == null ? "<unnamed>" : this.getName()) + " [" + this.getKindString() + "@" + this.hashCode() + "]";
    }

    protected String getKindString() {
        return NameUtils.approximateSimpleName(this.getClass());
    }

    @Override
    public Pipeline getPipeline() {
        Preconditions.checkState(this.pipeline != null, "Pipeline was null for %s. this probably means it was used as a %s after being deserialized, which not unsupported.", (Object)this.getClass().getCanonicalName(), (Object)PValue.class.getSimpleName());
        return this.pipeline;
    }

    @Override
    public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
        if (this.name == null) {
            this.setName(PValueBase.defaultName(transformName));
        }
    }

    static String defaultName(String transformName) {
        return String.format("%s.%s", transformName, "out");
    }
}

