/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

@Internal
public class PValues {
    private PValues() {
    }

    public static Map<TupleTag<?>, PCollection<?>> fullyExpand(Map<TupleTag<?>, PValue> partiallyExpanded) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<TupleTag<?>, PValue> pvalue : partiallyExpanded.entrySet()) {
            if (pvalue.getValue() instanceof PCollection) {
                PCollection previous = result.put(pvalue.getKey(), (PCollection)pvalue.getValue());
                Preconditions.checkArgument(previous == null, "Found conflicting %ss in flattened expansion of %s: %s maps to %s and %s", partiallyExpanded, TupleTag.class.getSimpleName(), pvalue.getKey(), previous, pvalue.getValue());
                continue;
            }
            if (pvalue.getValue().expand().size() == 1 && Iterables.getOnlyElement(pvalue.getValue().expand().values()).equals(pvalue.getValue())) {
                throw new IllegalStateException(String.format("Non %s %s that expands into itself %s", PCollection.class.getSimpleName(), PValue.class.getSimpleName(), pvalue.getValue()));
            }
            for (Map.Entry<TupleTag<?>, PValue> valueComponent : pvalue.getValue().expand().entrySet()) {
                if (!(valueComponent.getValue() instanceof PCollection)) {
                    throw new IllegalStateException(String.format("A %s contained in %s expanded to a non-%s: %s", PValue.class.getSimpleName(), partiallyExpanded, PCollection.class.getSimpleName(), valueComponent.getValue()));
                }
                PCollection previous = result.put(valueComponent.getKey(), (PCollection)valueComponent.getValue());
                Preconditions.checkArgument(previous == null, "Found conflicting %ss in flattened expansion of %s: %s maps to %s and %s", partiallyExpanded, TupleTag.class.getSimpleName(), valueComponent.getKey(), previous, valueComponent.getValue());
            }
        }
        return result;
    }

    public static Map<TupleTag<?>, PCollection<?>> expandOutput(POutput output) {
        return PValues.fullyExpand(output.expand());
    }

    public static Map<TupleTag<?>, PCollection<?>> expandInput(PInput input) {
        return PValues.fullyExpand(input.expand());
    }

    public static Map<TupleTag<?>, PCollection<?>> expandValue(PValue value) {
        return PValues.fullyExpand(value.expand());
    }
}

