/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Objects;
import org.github.jamm.MemoryMeter;
import org.github.jamm.Unmetered;

abstract class MemoryMeterBase
extends MemoryMeter {
    private static final String outerClassReference = "this\\$[0-9]+";
    private final ClassValue<MethodHandle[]> declaredClassFieldsCache = new ClassValue<MethodHandle[]>(){

        @Override
        protected MethodHandle[] computeValue(Class<?> type) {
            return MemoryMeterBase.this.declaredClassFields0(type);
        }
    };

    MemoryMeterBase(MemoryMeter.Builder builder) {
        super(builder);
    }

    @Override
    public long measure(Object obj) {
        Class<?> type = obj.getClass();
        if (type.isArray()) {
            return this.measureArray(obj, type);
        }
        return this.measureNonArray(obj, type);
    }

    abstract long measureArray(Object var1, Class<?> var2);

    abstract long measureNonArray(Object var1, Class<?> var2);

    @Override
    public final long measureDeep(Object object) {
        Objects.requireNonNull(object);
        if (((Boolean)this.ignoreClass.get(object.getClass())).booleanValue()) {
            return 0L;
        }
        VisitedSet tracker = new VisitedSet();
        tracker.add(object);
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.push(object);
        long total = 0L;
        while (!stack.isEmpty()) {
            Object current = stack.pop();
            Class<?> type = current.getClass();
            long size = this.measure(current);
            total += size;
            if (type.isArray()) {
                if (type.getComponentType().isPrimitive()) continue;
                for (Object child : (Object[])current) {
                    if (child == null || !tracker.add(child) || ((Boolean)this.ignoreClass.get(child.getClass())).booleanValue()) continue;
                    stack.push(child);
                }
                continue;
            }
            if (this.byteBufferMode != 0 && ByteBuffer.class.isAssignableFrom(type)) {
                ByteBuffer bb = (ByteBuffer)current;
                if (this.byteBufferMode == 1) {
                    total += (long)bb.remaining();
                    continue;
                }
                if (this.byteBufferMode == 2) continue;
                if (this.byteBufferMode == 3) {
                    if (bb.isDirect()) continue;
                    if (bb.capacity() > bb.remaining()) {
                        total -= size;
                        total += (long)bb.remaining();
                        continue;
                    }
                }
            }
            Object referent = this.ignoreNonStrongReferences && current instanceof Reference ? ((Reference)current).get() : null;
            try {
                Class<?> cls = current.getClass();
                for (MethodHandle field : this.declaredClassFields(cls)) {
                    Object child = field.invoke(current);
                    if (child == null || !tracker.add(child) || ((Boolean)this.ignoreClass.get(child.getClass())).booleanValue() || child == referent) continue;
                    stack.push(child);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return total;
    }

    private MethodHandle[] declaredClassFields(Class<?> cls) {
        return this.declaredClassFieldsCache.get(cls);
    }

    private MethodHandle[] declaredClassFields0(Class<?> cls) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ArrayList<MethodHandle> mhs = new ArrayList<MethodHandle>();
        while (!MemoryMeterBase.skipClass(cls)) {
            for (Field f : cls.getDeclaredFields()) {
                if (f.getType().isPrimitive() || Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(Unmetered.class) || this.ignoreOuterClassReference && f.getName().matches(outerClassReference) || ((Boolean)this.ignoreClass.get(f.getType())).booleanValue()) continue;
                boolean acc = f.isAccessible();
                try {
                    if (!acc) {
                        f.setAccessible(true);
                    }
                    mhs.add(lookup.unreflectGetter(f));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (!acc) {
                        f.setAccessible(false);
                    }
                }
            }
            cls = cls.getSuperclass();
        }
        return mhs.toArray(new MethodHandle[0]);
    }

    static final class VisitedSet {
        int size;
        Object[] table = new Object[16];

        VisitedSet() {
        }

        boolean add(Object o) {
            while (true) {
                Object item;
                Object[] tab = this.table;
                int len = tab.length;
                int mask = len - 1;
                int i = VisitedSet.index(o, mask);
                while ((item = tab[i]) != null) {
                    if (item == o) {
                        return false;
                    }
                    i = VisitedSet.inc(i, len);
                }
                int s2 = this.size + 1;
                if (s2 * 3 <= len) {
                    this.size = s2;
                    tab[i] = o;
                    return true;
                }
                this.resize();
            }
        }

        private void resize() {
            Object[] tab = this.table;
            int newLength = tab.length << 1;
            if (newLength < 0) {
                throw new IllegalStateException("too many objects visited");
            }
            Object[] n = new Object[newLength];
            int mask = newLength - 1;
            for (Object o : tab) {
                if (o == null) continue;
                int i = VisitedSet.index(o, mask);
                while (n[i] != null) {
                    i = VisitedSet.inc(i, newLength);
                }
                n[i] = o;
            }
            this.table = n;
        }

        private static int index(Object o, int mask) {
            return System.identityHashCode(o) & mask;
        }

        private static int inc(int i, int len) {
            int n = i + 1;
            return n >= len ? 0 : n;
        }
    }
}

