/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.util.concurrent.ConcurrentHashMap;
import org.github.jamm.MemoryMeter;
import org.github.jamm.MemoryMeterBase;

final class MemoryMeterInstrumentation
extends MemoryMeterBase {
    static Instrumentation instrumentation;
    private final ConcurrentHashMap<Class<?>, Long> shallowClassCache = new ConcurrentHashMap();

    static boolean hasInstrumentation() {
        return instrumentation != null && !Boolean.getBoolean("jamm.no-instrumentation");
    }

    MemoryMeterInstrumentation(MemoryMeter.Builder builder) {
        super(builder);
    }

    @Override
    long measureArray(Object obj, Class<?> type) {
        return this.sizeOfArray(Array.getLength(obj), type.getComponentType());
    }

    @Override
    long measureNonArray(Object obj, Class<?> type) {
        Long sz = this.shallowClassCache.get(type);
        if (sz != null) {
            return sz;
        }
        long szp = instrumentation.getObjectSize(obj);
        this.shallowClassCache.put(type, szp);
        return szp;
    }
}

