/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.github.jamm.MemoryMeter;
import org.github.jamm.MemoryMeterRef;

final class MemoryMeterSpec
extends MemoryMeterRef {
    private static boolean warned;

    MemoryMeterSpec(MemoryMeter.Builder builder) {
        super(builder, MemoryMeterSpec::sizeOf);
        MemoryMeterSpec.maybeWarn();
    }

    private static void maybeWarn() {
        if (warned) {
            return;
        }
        warned = true;
        System.err.println("***********************************************************************************");
        System.err.println("** jamm will GUESS the size of objects on heap. This is wrong and");
        System.err.println("** results in wrong assumptions of the free/occupied Java heap and");
        System.err.println("** potentially in OOMs. The implementation does not always consider");
        System.err.println("** Java object layouts under all circumstances for all JVMs.");
        System.err.println("**");
        System.err.println("** Solutions:");
        System.err.println("** - Use a JDK/JVM with JEP-8249196");
        System.err.println("** - Load jamm as an agent into the JVM");
        System.err.println("***********************************************************************************");
    }

    private static long sizeOf(Class<?> type) {
        long size = MemoryMeterSpec.sizeOf(SPEC.getObjectHeaderSize(), type);
        size = MemoryMeterSpec.roundTo(size, SPEC.getObjectAlignment());
        return size;
    }

    private static long sizeOf(long size, Class<?> type) {
        Class<?> superclass = type.getSuperclass();
        if (superclass != Object.class && superclass != null) {
            size = MemoryMeterSpec.sizeOf(size, superclass);
        }
        size = MemoryMeterSpec.sizeOfDeclaredFields(size, type);
        return size;
    }

    private static long sizeOfDeclaredFields(long size, Class<?> type) {
        boolean any = false;
        for (Field f : type.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            Class<?> t = f.getType();
            if (!(any || t != Long.TYPE && t.isPrimitive() && t != Double.TYPE)) {
                any = true;
                size = MemoryMeterSpec.roundTo(size, SPEC.getObjectAlignment());
            }
            size += (long)MemoryMeterSpec.sizeOfField(t);
        }
        return size;
    }
}

