/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateFetchingIterators;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.stream.PrefetchableIterable;
import org.apache.beam.sdk.fn.stream.PrefetchableIterables;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BagUserState<@UnknownKeyFor T> {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cache;
    private final @UnknownKeyFor @NonNull @Initialized BeamFnStateClient beamFnStateClient;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest request;
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder;
    private final @UnknownKeyFor @NonNull @Initialized StateFetchingIterators.CachingStateIterable<T> oldValues;
    private @UnknownKeyFor @NonNull @Initialized List<T> newValues;
    private @UnknownKeyFor @NonNull @Initialized boolean isCleared;
    private @UnknownKeyFor @NonNull @Initialized boolean isClosed;
    static final @UnknownKeyFor @NonNull @Initialized int BAG_APPEND_BATCHING_LIMIT = 0xA00000;

    public BagUserState(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cache, @UnknownKeyFor @NonNull @Initialized BeamFnStateClient beamFnStateClient, @UnknownKeyFor @NonNull @Initialized String instructionId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateKey stateKey, @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        Preconditions.checkArgument((boolean)stateKey.hasBagUserState(), (String)"Expected BagUserState StateKey but received %s.", (Object)stateKey);
        this.cache = cache;
        this.beamFnStateClient = beamFnStateClient;
        this.valueCoder = valueCoder;
        this.request = BeamFnApi.StateRequest.newBuilder().setInstructionId(instructionId).setStateKey(stateKey).build();
        this.oldValues = StateFetchingIterators.readAllAndDecodeStartingFrom(this.cache, beamFnStateClient, this.request, valueCoder);
        this.newValues = new ArrayList<T>();
    }

    public @UnknownKeyFor @NonNull @Initialized PrefetchableIterable<T> get() {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        if (this.isCleared) {
            return PrefetchableIterables.limit(Collections.unmodifiableList(this.newValues), (int)this.newValues.size());
        }
        if (this.newValues.isEmpty()) {
            return this.oldValues;
        }
        return PrefetchableIterables.concat((Iterable[])new Iterable[]{this.oldValues, Iterables.limit(Collections.unmodifiableList(this.newValues), (int)this.newValues.size())});
    }

    public void append(T t) {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        this.newValues.add(t);
    }

    public void clear() {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        this.isCleared = true;
        this.newValues = new ArrayList<T>();
    }

    public void asyncClose() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"Bag user state is no longer usable because it is closed for %s", (Object)this.request.getStateKey());
        this.isClosed = true;
        if (!this.isCleared && this.newValues.isEmpty()) {
            return;
        }
        if (this.isCleared) {
            this.beamFnStateClient.handle(this.request.toBuilder().setClear(BeamFnApi.StateClearRequest.getDefaultInstance()));
        }
        if (!this.newValues.isEmpty()) {
            ByteStringOutputStream out = new ByteStringOutputStream();
            for (T newValue : this.newValues) {
                int previousSize = out.size();
                this.valueCoder.encode(newValue, (OutputStream)out);
                if (out.size() > 0xA00000 && previousSize > 0) {
                    this.beamFnStateClient.handle(this.request.toBuilder().setAppend(BeamFnApi.StateAppendRequest.newBuilder().setData(out.consumePrefixToByteString(previousSize))));
                }
                if (out.size() <= 0xA00000) continue;
                this.beamFnStateClient.handle(this.request.toBuilder().setAppend(BeamFnApi.StateAppendRequest.newBuilder().setData(out.toByteStringAndReset())));
            }
            if (out.size() > 0) {
                this.beamFnStateClient.handle(this.request.toBuilder().setAppend(BeamFnApi.StateAppendRequest.newBuilder().setData(out.toByteStringAndReset())));
            }
        }
        if (this.isCleared) {
            this.oldValues.clearAndAppend(this.newValues);
        } else {
            this.oldValues.append(this.newValues);
        }
    }
}

