/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;

@Description(value="Options that are used to configure Google BigQuery. See https://cloud.google.com/bigquery/what-is-bigquery for details on BigQuery.")
public interface BigQueryOptions
extends ApplicationNameOptions,
GcpOptions,
PipelineOptions,
StreamingOptions {
    @Description(value="Temporary dataset for BigQuery table operations. Supported values are \"bigquery.googleapis.com/{dataset}\"")
    @Default.String(value="bigquery.googleapis.com/cloud_dataflow")
    public String getTempDatasetId();

    public void setTempDatasetId(String var1);

    @Description(value="If specified, the given write timeout will be set to HTTP requests created tocommunicate with BigQuery service.")
    @Default.Integer(value=0)
    public Integer getHTTPWriteTimeout();

    public void setHTTPWriteTimeout(Integer var1);

    @Description(value="If specified, the given number of maximum concurrent threads will be used to insert rows from one bundle to BigQuery service with streaming insert API.")
    @Default.Integer(value=3)
    public Integer getInsertBundleParallelism();

    public void setInsertBundleParallelism(Integer var1);

    @Description(value="The number of keys used per table when doing streaming inserts to BigQuery.")
    @Default.Integer(value=50)
    public Integer getNumStreamingKeys();

    public void setNumStreamingKeys(Integer var1);

    @Description(value="The maximum number of rows to batch in a single streaming insert to BigQuery.")
    @Default.Long(value=500L)
    public Long getMaxStreamingRowsToBatch();

    public void setMaxStreamingRowsToBatch(Long var1);

    @Description(value="The maximum byte size of a single streaming insert to BigQuery.")
    @Default.Long(value=65536L)
    public Long getMaxStreamingBatchSize();

    public void setMaxStreamingBatchSize(Long var1);
}

