/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.TestBigQueryOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestBigQuery
implements TestRule {
    private static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormat.forPattern((String)"YYYY_MM_dd_HH_mm_ss_SSS");
    private TestBigQueryOptions pipelineOptions;
    private Schema schema;
    private Table table;
    private BigQueryServices.DatasetService datasetService;

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public static TestBigQuery create(Schema tableSchema) {
        return new TestBigQuery((TestBigQueryOptions)TestPipeline.testingPipelineOptions().as(TestBigQueryOptions.class), tableSchema);
    }

    private TestBigQuery(TestBigQueryOptions pipelineOptions, Schema tableSchema) {
        this.pipelineOptions = pipelineOptions;
        this.schema = tableSchema;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (TestBigQuery.this.datasetService != null) {
                    throw new AssertionError((Object)("BigQuery test was not shutdown previously. Table is'" + TestBigQuery.this.table + "'. Current test: " + description.getDisplayName()));
                }
                try {
                    TestBigQuery.this.initializeBigQuery(description);
                    base.evaluate();
                }
                finally {
                    TestBigQuery.this.tearDown();
                }
            }
        };
    }

    private void initializeBigQuery(Description description) throws IOException, InterruptedException {
        this.datasetService = new BigQueryServicesImpl().getDatasetService(this.pipelineOptions);
        this.table = this.createTable(description);
    }

    private Table createTable(Description description) throws IOException, InterruptedException {
        TableReference tableReference = new TableReference().setProjectId(this.pipelineOptions.getProject()).setDatasetId(this.pipelineOptions.getTargetDataset()).setTableId(TestBigQuery.createRandomizedName(description));
        this.table = new Table().setTableReference(tableReference).setSchema(BigQueryUtils.toTableSchema(this.schema)).setDescription("Table created for " + description.getDisplayName() + " by TestBigQueryRule. Should be automatically cleaned up after test completion.");
        if (this.datasetService.getTable(tableReference) != null) {
            throw new IllegalStateException("Table '" + tableReference + "' already exists. It should have been cleaned up by the test rule.");
        }
        this.datasetService.createTable(this.table);
        return this.table;
    }

    private void tearDown() throws IOException, InterruptedException {
        if (this.datasetService == null) {
            return;
        }
        try {
            if (this.table != null) {
                this.datasetService.deleteTable(this.table.getTableReference());
            }
        }
        finally {
            this.datasetService = null;
            this.table = null;
        }
    }

    static String createRandomizedName(Description description) throws IOException {
        StringBuilder topicName = new StringBuilder();
        if (description.getClassName() != null) {
            try {
                topicName.append(Class.forName(description.getClassName()).getSimpleName()).append("_");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (description.getMethodName() != null) {
            topicName.append(description.getMethodName().replaceAll("[\\[\\]\\.]", "_")).append("_");
        }
        DATETIME_FORMAT.printTo(topicName, (ReadableInstant)Instant.now());
        return topicName.toString() + "_" + String.valueOf(Math.abs(ThreadLocalRandom.current().nextLong()));
    }

    public String tableSpec() {
        return String.format("%s:%s.%s", this.table.getTableReference().getProjectId(), this.table.getTableReference().getDatasetId(), this.table.getTableReference().getTableId());
    }

    public TableReference tableReference() {
        return this.table.getTableReference();
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public TableDataInsertAllResponse insertRows(Schema rowSchema, Row ... rows) throws IOException {
        List bqRows = (List)Arrays.stream(rows).map(row -> new TableDataInsertAllRequest.Rows().setJson((Map)BigQueryUtils.toTableRow(row))).collect(ImmutableList.toImmutableList());
        Bigquery bq = TestBigQuery.newBigQueryClient(this.pipelineOptions);
        return (TableDataInsertAllResponse)bq.tabledata().insertAll(this.pipelineOptions.getProject(), this.pipelineOptions.getTargetDataset(), this.table.getTableReference().getTableId(), new TableDataInsertAllRequest().setRows(bqRows)).execute();
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public List<Row> getFlatJsonRows(Schema rowSchema) {
        Bigquery bq = TestBigQuery.newBigQueryClient(this.pipelineOptions);
        return this.bqRowsToBeamRows(this.getSchema(bq), this.getTableRows(bq), rowSchema);
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public RowsAssertion assertThatAllRows(Schema rowSchema) {
        return new RowsAssertion(rowSchema);
    }

    private void pollAndAssert(Schema rowSchema, Matcher<Iterable<? extends Row>> matcher, Duration duration) {
        DateTime start = DateTime.now();
        while (true) {
            try {
                this.doAssert(rowSchema, matcher);
            }
            catch (AssertionError assertionError) {
                if (Seconds.secondsBetween((ReadableInstant)start, (ReadableInstant)DateTime.now()).isGreaterThan(duration.toStandardSeconds())) {
                    throw assertionError;
                }
                this.sleep(15000L);
                continue;
            }
            break;
        }
    }

    private void doAssert(Schema rowSchema, Matcher<Iterable<? extends Row>> matcher) {
        MatcherAssert.assertThat(this.getFlatJsonRows(rowSchema), matcher);
    }

    private List<Row> bqRowsToBeamRows(TableSchema bqSchema, List<TableRow> bqRows, Schema rowSchema) {
        if (bqRows == null) {
            return Collections.emptyList();
        }
        return bqRows.stream().map(bqRow -> BigQueryUtils.toBeamRow(rowSchema, bqSchema, bqRow)).collect(Collectors.toList());
    }

    private List<TableRow> beamRowsToBqRows(List<Row> bqRows) {
        if (bqRows == null) {
            return Collections.emptyList();
        }
        return bqRows.stream().map(BigQueryUtils::toTableRow).collect(Collectors.toList());
    }

    private TableSchema getSchema(Bigquery bq) {
        try {
            return ((Table)bq.tables().get(this.pipelineOptions.getProject(), this.pipelineOptions.getTargetDataset(), this.table.getTableReference().getTableId()).execute()).getSchema();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<TableRow> getTableRows(Bigquery bq) {
        try {
            return ((TableDataList)bq.tabledata().list(this.pipelineOptions.getProject(), this.pipelineOptions.getTargetDataset(), this.table.getTableReference().getTableId()).execute()).getRows();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Bigquery newBigQueryClient(BigQueryOptions options) {
        return new Bigquery.Builder(Transport.getTransport(), Transport.getJsonFactory(), TestBigQuery.chainHttpRequestInitializer(options.getGcpCredential(), (HttpRequestInitializer)new RetryHttpRequestInitializer((Collection)ImmutableList.of((Object)404)))).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace()).build();
    }

    private static HttpRequestInitializer chainHttpRequestInitializer(Credentials credential, HttpRequestInitializer httpRequestInitializer) {
        if (credential == null) {
            return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new NullCredentialInitializer(), httpRequestInitializer});
        }
        return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), httpRequestInitializer});
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface PollingAssertion {
        public void pollFor(Duration var1);
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public class RowsAssertion {
        private final Schema rowSchema;

        private RowsAssertion(Schema rowSchema) {
            this.rowSchema = rowSchema;
        }

        public PollingAssertion eventually(Matcher<Iterable<? extends Row>> matcher) {
            return duration -> TestBigQuery.this.pollAndAssert(this.rowSchema, (Matcher<Iterable<? extends Row>>)matcher, duration);
        }

        public void now(Matcher<Iterable<? extends Row>> matcher) {
            TestBigQuery.this.doAssert(this.rowSchema, (Matcher<Iterable<? extends Row>>)matcher);
        }
    }
}

