/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertError;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public final class WriteResult
implements POutput {
    private final Pipeline pipeline;
    private final TupleTag<TableRow> failedInsertsTag;
    private final PCollection<TableRow> failedInserts;
    private final TupleTag<BigQueryInsertError> failedInsertsWithErrTag;
    private final PCollection<BigQueryInsertError> failedInsertsWithErr;

    static WriteResult in(Pipeline pipeline, TupleTag<TableRow> failedInsertsTag, PCollection<TableRow> failedInserts) {
        return new WriteResult(pipeline, failedInsertsTag, failedInserts, null, null);
    }

    static WriteResult withExtendedErrors(Pipeline pipeline, TupleTag<BigQueryInsertError> failedInsertsTag, PCollection<BigQueryInsertError> failedInserts) {
        return new WriteResult(pipeline, null, null, failedInsertsTag, failedInserts);
    }

    public Map<TupleTag<?>, PValue> expand() {
        if (this.failedInsertsTag != null) {
            return ImmutableMap.of(this.failedInsertsTag, this.failedInserts);
        }
        return ImmutableMap.of(this.failedInsertsWithErrTag, this.failedInsertsWithErr);
    }

    private WriteResult(Pipeline pipeline, TupleTag<TableRow> failedInsertsTag, PCollection<TableRow> failedInserts, TupleTag<BigQueryInsertError> failedInsertsWithErrTag, PCollection<BigQueryInsertError> failedInsertsWithErr) {
        this.pipeline = pipeline;
        this.failedInsertsTag = failedInsertsTag;
        this.failedInserts = failedInserts;
        this.failedInsertsWithErrTag = failedInsertsWithErrTag;
        this.failedInsertsWithErr = failedInsertsWithErr;
    }

    public PCollection<TableRow> getFailedInserts() {
        Preconditions.checkArgument((this.failedInsertsTag != null ? 1 : 0) != 0, (Object)"Cannot use getFailedInserts as this WriteResult uses extended errors information. Use getFailedInsertsWithErr instead");
        return this.failedInserts;
    }

    public PCollection<BigQueryInsertError> getFailedInsertsWithErr() {
        Preconditions.checkArgument((this.failedInsertsWithErrTag != null ? 1 : 0) != 0, (Object)"Cannot use getFailedInsertsWithErr as this WriteResult does not use extended errors. Use getFailedInserts instead");
        return this.failedInsertsWithErr;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
    }
}

