/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.WriteBundlesToFiles;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.sdk.values.TupleTag;

class WritePartition<DestinationT>
extends DoFn<Iterable<WriteBundlesToFiles.Result<DestinationT>>, KV<ShardedKey<DestinationT>, List<String>>> {
    private final boolean singletonTable;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private final PCollectionView<String> tempFilePrefix;
    @Nullable
    private TupleTag<KV<ShardedKey<DestinationT>, List<String>>> multiPartitionsTag;
    private TupleTag<KV<ShardedKey<DestinationT>, List<String>>> singlePartitionTag;

    WritePartition(boolean singletonTable, DynamicDestinations<?, DestinationT> dynamicDestinations, PCollectionView<String> tempFilePrefix, TupleTag<KV<ShardedKey<DestinationT>, List<String>>> multiPartitionsTag, TupleTag<KV<ShardedKey<DestinationT>, List<String>>> singlePartitionTag) {
        this.singletonTable = singletonTable;
        this.dynamicDestinations = dynamicDestinations;
        this.tempFilePrefix = tempFilePrefix;
        this.multiPartitionsTag = multiPartitionsTag;
        this.singlePartitionTag = singlePartitionTag;
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        DestinationData destinationData;
        Object destination;
        ArrayList results = Lists.newArrayList((Iterable)((Iterable)c.element()));
        if (results.isEmpty() && this.singletonTable) {
            String tempFilePrefix = (String)c.sideInput(this.tempFilePrefix);
            TableRowWriter writer = new TableRowWriter(tempFilePrefix);
            writer.close();
            TableRowWriter.Result result = writer.getResult();
            results.add(new WriteBundlesToFiles.Result<DestinationT>(result.resourceId.toString(), result.byteSize, this.dynamicDestinations.getDestination(null)));
        }
        HashMap currentResults = Maps.newHashMap();
        for (WriteBundlesToFiles.Result result : results) {
            destination = result.destination;
            destinationData = currentResults.computeIfAbsent(destination, k -> new DestinationData());
            PartitionData latestPartition = destinationData.getLatestPartition();
            if (!latestPartition.canAccept(1, result.fileByteSize)) {
                latestPartition = new PartitionData();
                destinationData.addPartition(latestPartition);
            }
            latestPartition.addFilename(result.filename);
            latestPartition.addFiles(1);
            latestPartition.addBytes(result.fileByteSize);
        }
        for (Map.Entry entry : currentResults.entrySet()) {
            destination = entry.getKey();
            destinationData = (DestinationData)entry.getValue();
            TupleTag<KV<ShardedKey<DestinationT>, List<String>>> outputTag = destinationData.getPartitions().size() == 1 ? this.singlePartitionTag : this.multiPartitionsTag;
            for (int i = 0; i < destinationData.getPartitions().size(); ++i) {
                PartitionData partitionData = destinationData.getPartitions().get(i);
                c.output(outputTag, (Object)KV.of((Object)ShardedKey.of(destination, (int)(i + 1)), partitionData.getFilenames()));
            }
        }
    }

    private static class DestinationData {
        private List<PartitionData> partitions = Lists.newArrayList();

        DestinationData() {
            this.partitions.add(new PartitionData());
        }

        List<PartitionData> getPartitions() {
            return this.partitions;
        }

        PartitionData getLatestPartition() {
            return this.partitions.get(this.partitions.size() - 1);
        }

        void addPartition(PartitionData partition) {
            this.partitions.add(partition);
        }
    }

    private static class PartitionData {
        private int numFiles = 0;
        private long byteSize = 0L;
        private List<String> filenames = Lists.newArrayList();

        private PartitionData() {
        }

        int getNumFiles() {
            return this.numFiles;
        }

        void addFiles(int numFiles) {
            this.numFiles += numFiles;
        }

        long getByteSize() {
            return this.byteSize;
        }

        void addBytes(long numBytes) {
            this.byteSize += numBytes;
        }

        List<String> getFilenames() {
            return this.filenames;
        }

        void addFilename(String filename) {
            this.filenames.add(filename);
        }

        boolean canAccept(int numFiles, long numBytes) {
            return this.numFiles + numFiles <= 10000 && this.byteSize + numBytes <= 0xB0000000000L;
        }
    }
}

