/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.PCollectionView;

@VisibleForTesting
class NaiveSpannerReadFn
extends DoFn<ReadOperation, Struct> {
    private final SpannerConfig config;
    @Nullable
    private final PCollectionView<Transaction> transaction;
    private transient SpannerAccessor spannerAccessor;

    NaiveSpannerReadFn(SpannerConfig config, @Nullable PCollectionView<Transaction> transaction) {
        this.config = config;
        this.transaction = transaction;
    }

    NaiveSpannerReadFn(SpannerConfig config) {
        this(config, null);
    }

    @DoFn.Setup
    public void setup() throws Exception {
        this.spannerAccessor = this.config.connectToSpanner();
    }

    @DoFn.Teardown
    public void teardown() throws Exception {
        this.spannerAccessor.close();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        TimestampBound timestampBound = TimestampBound.strong();
        if (this.transaction != null) {
            Transaction transaction = (Transaction)c.sideInput(this.transaction);
            timestampBound = TimestampBound.ofReadTimestamp((Timestamp)transaction.timestamp());
        }
        ReadOperation op = (ReadOperation)c.element();
        DatabaseClient databaseClient = this.spannerAccessor.getDatabaseClient();
        try (ReadOnlyTransaction readOnlyTransaction = databaseClient.readOnlyTransaction(timestampBound);){
            ResultSet resultSet = this.execute(op, readOnlyTransaction);
            while (resultSet.next()) {
                c.output((Object)resultSet.getCurrentRowAsStruct());
            }
        }
    }

    private ResultSet execute(ReadOperation op, ReadOnlyTransaction readOnlyTransaction) {
        if (op.getQuery() != null) {
            return readOnlyTransaction.executeQuery(op.getQuery(), new Options.QueryOption[0]);
        }
        if (op.getIndex() != null) {
            return readOnlyTransaction.readUsingIndex(op.getTable(), op.getIndex(), op.getKeySet(), op.getColumns(), new Options.ReadOption[0]);
        }
        return readOnlyTransaction.read(op.getTable(), op.getKeySet(), op.getColumns(), new Options.ReadOption[0]);
    }
}

