/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTableHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.RetryManager;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiFinalizeWritesDoFn;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TwoLevelMessageConverterCache;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageApiWriteUnshardedRecords<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, byte[]>>, PCollection<Void>> {
    private static final Logger LOG = LoggerFactory.getLogger(StorageApiWriteUnshardedRecords.class);
    private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final String kmsKey;
    private final BigQueryServices bqServices;
    private final Coder<DestinationT> destinationCoder;
    private static final ExecutorService closeWriterExecutor = Executors.newCachedThreadPool();
    private static final Cache<String, BigQueryServices.StreamAppendClient> APPEND_CLIENTS = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(removal -> {
        BigQueryServices.StreamAppendClient streamAppendClient = (BigQueryServices.StreamAppendClient)removal.getValue();
        StorageApiWriteUnshardedRecords.runAsyncIgnoreFailure(closeWriterExecutor, streamAppendClient::close);
    }).build();

    private static void runAsyncIgnoreFailure(ExecutorService executor, ThrowingRunnable task) {
        executor.submit(() -> {
            try {
                task.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public StorageApiWriteUnshardedRecords(StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryIO.Write.CreateDisposition createDisposition, String kmsKey, BigQueryServices bqServices, Coder<DestinationT> destinationCoder) {
        this.dynamicDestinations = dynamicDestinations;
        this.createDisposition = createDisposition;
        this.kmsKey = kmsKey;
        this.bqServices = bqServices;
        this.destinationCoder = destinationCoder;
    }

    public PCollection<Void> expand(PCollection<KV<DestinationT, byte[]>> input) {
        String operationName = input.getName() + "/" + this.getName();
        return (PCollection)((PCollection)((PCollection)input.apply("Write Records", (PTransform)ParDo.of(new WriteRecordsDoFn<DestinationT, ElementT>(operationName, this.dynamicDestinations, this.bqServices, this.destinationCoder, this.createDisposition, this.kmsKey, false)).withSideInputs(this.dynamicDestinations.getSideInputs()))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of())).apply("Reshuffle", (PTransform)Reshuffle.of())).apply("Finalize writes", (PTransform)ParDo.of((DoFn)new StorageApiFinalizeWritesDoFn(this.bqServices)));
    }

    static class WriteRecordsDoFn<DestinationT, ElementT>
    extends DoFn<KV<DestinationT, byte[]>, KV<String, String>> {
        private Map<DestinationT, DestinationState> destinations = Maps.newHashMap();
        private final TwoLevelMessageConverterCache<DestinationT, ElementT> messageConverters;
        @Nullable
        private transient BigQueryServices.DatasetService datasetService;
        private int numPendingRecords = 0;
        private int numPendingRecordBytes = 0;
        private static final int FLUSH_THRESHOLD_RECORDS = 100;
        private static final int FLUSH_THRESHOLD_RECORD_BYTES = 0x200000;
        private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
        private final BigQueryServices bqServices;
        private final Coder<DestinationT> destinationCoder;
        private final BigQueryIO.Write.CreateDisposition createDisposition;
        private final String kmsKey;
        private final boolean useDefaultStream;

        WriteRecordsDoFn(String operationName, StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryServices bqServices, Coder<DestinationT> destinationCoder, BigQueryIO.Write.CreateDisposition createDisposition, String kmsKey, boolean useDefaultStream) {
            this.messageConverters = new TwoLevelMessageConverterCache(operationName);
            this.dynamicDestinations = dynamicDestinations;
            this.bqServices = bqServices;
            this.destinationCoder = destinationCoder;
            this.createDisposition = createDisposition;
            this.kmsKey = kmsKey;
            this.useDefaultStream = useDefaultStream;
        }

        boolean shouldFlush() {
            return this.numPendingRecords > 100 || this.numPendingRecordBytes > 0x200000;
        }

        void flushIfNecessary() throws Exception {
            if (this.shouldFlush()) {
                this.flushAll();
            }
        }

        void flushAll() throws Exception {
            RetryManager<AppendRowsResponse, RetryManager.Operation.Context<AppendRowsResponse>> retryManager = new RetryManager<AppendRowsResponse, RetryManager.Operation.Context<AppendRowsResponse>>(Duration.standardSeconds((long)1L), Duration.standardSeconds((long)10L), 1000);
            for (DestinationState destinationState : this.destinations.values()) {
                destinationState.flush(retryManager);
            }
            retryManager.run(true);
            this.numPendingRecords = 0;
            this.numPendingRecordBytes = 0;
        }

        private void initializeDatasetService(PipelineOptions pipelineOptions) {
            if (this.datasetService == null) {
                this.datasetService = this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
            }
        }

        @DoFn.StartBundle
        public void startBundle() throws IOException {
            this.destinations = Maps.newHashMap();
            this.numPendingRecords = 0;
            this.numPendingRecordBytes = 0;
        }

        DestinationState createDestinationState(DoFn.ProcessContext c, DestinationT destination, BigQueryServices.DatasetService datasetService) {
            StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter;
            TableDestination tableDestination1 = this.dynamicDestinations.getTable(destination);
            Preconditions.checkArgument((tableDestination1 != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may not return null, but %s returned null for destination %s", this.dynamicDestinations, destination);
            Supplier schemaSupplier = () -> this.dynamicDestinations.getSchema(destination);
            TableDestination createdTable = CreateTableHelpers.possiblyCreateTable(c, tableDestination1, (Supplier<TableSchema>)schemaSupplier, this.createDisposition, this.destinationCoder, this.kmsKey, this.bqServices);
            try {
                messageConverter = this.messageConverters.get(destination, this.dynamicDestinations, datasetService);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return new DestinationState(createdTable.getTableUrn(), messageConverter, datasetService, this.useDefaultStream);
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c, PipelineOptions pipelineOptions, @DoFn.Element KV<DestinationT, byte[]> element) throws Exception {
            this.initializeDatasetService(pipelineOptions);
            this.dynamicDestinations.setSideInputAccessorFromProcessContext(c);
            DestinationState state = this.destinations.computeIfAbsent(element.getKey(), k -> this.createDestinationState(c, k, this.datasetService));
            this.flushIfNecessary();
            state.addMessage((byte[])element.getValue());
            ++this.numPendingRecords;
            this.numPendingRecordBytes += ((byte[])element.getValue()).length;
        }

        @DoFn.FinishBundle
        public void finishBundle(DoFn.FinishBundleContext context) throws Exception {
            this.flushAll();
            if (!this.useDefaultStream) {
                for (DestinationState state : this.destinations.values()) {
                    context.output((Object)KV.of((Object)state.tableUrn, (Object)state.streamName), BoundedWindow.TIMESTAMP_MAX_VALUE.minus((ReadableDuration)Duration.millis((long)1L)), (BoundedWindow)GlobalWindow.INSTANCE);
                }
            }
        }

        @DoFn.Teardown
        public void teardown() {
            this.destinations.clear();
            try {
                if (this.datasetService != null) {
                    this.datasetService.close();
                    this.datasetService = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        class DestinationState {
            private final String tableUrn;
            private final StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter;
            private String streamName = "";
            @Nullable
            private BigQueryServices.StreamAppendClient streamAppendClient = null;
            private long currentOffset = 0L;
            private List<ByteString> pendingMessages;
            @Nullable
            private transient BigQueryServices.DatasetService datasetService;
            private final Counter recordsAppended = Metrics.counter(WriteRecordsDoFn.class, (String)"recordsAppended");
            private final Counter appendFailures = Metrics.counter(WriteRecordsDoFn.class, (String)"appendFailures");
            private final boolean useDefaultStream;

            public DestinationState(String tableUrn, StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter, BigQueryServices.DatasetService datasetService, boolean useDefaultStream) {
                this.tableUrn = tableUrn;
                this.messageConverter = messageConverter;
                this.pendingMessages = Lists.newArrayList();
                this.datasetService = datasetService;
                this.useDefaultStream = useDefaultStream;
            }

            String getDefaultStreamName() {
                return BigQueryHelpers.stripPartitionDecorator(this.tableUrn) + "/streams/_default";
            }

            BigQueryServices.StreamAppendClient getWriteStream() {
                try {
                    if (this.streamAppendClient == null) {
                        this.streamName = !this.useDefaultStream ? ((BigQueryServices.DatasetService)Preconditions.checkNotNull((Object)this.datasetService)).createWriteStream(this.tableUrn, WriteStream.Type.PENDING).getName() : this.getDefaultStreamName();
                        this.streamAppendClient = (BigQueryServices.StreamAppendClient)APPEND_CLIENTS.get((Object)this.streamName, () -> this.datasetService.getStreamAppendClient(this.streamName, this.messageConverter.getSchemaDescriptor()));
                        this.currentOffset = 0L;
                    }
                    return this.streamAppendClient;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            void invalidateWriteStream() {
                try {
                    StorageApiWriteUnshardedRecords.runAsyncIgnoreFailure(closeWriterExecutor, this.streamAppendClient::close);
                    this.streamAppendClient = null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            void addMessage(byte[] message) throws Exception {
                this.pendingMessages.add(ByteString.copyFrom((byte[])message));
            }

            void flush(RetryManager<AppendRowsResponse, RetryManager.Operation.Context<AppendRowsResponse>> retryManager) throws Exception {
                if (this.pendingMessages.isEmpty()) {
                    return;
                }
                ProtoRows.Builder inserts = ProtoRows.newBuilder();
                for (ByteString m : this.pendingMessages) {
                    inserts.addSerializedRows(m);
                }
                ProtoRows protoRows = inserts.build();
                this.pendingMessages.clear();
                retryManager.addOperation(c -> {
                    try {
                        BigQueryServices.StreamAppendClient writeStream = this.getWriteStream();
                        long offset = -1L;
                        if (!this.useDefaultStream) {
                            offset = this.currentOffset;
                            this.currentOffset += (long)inserts.getSerializedRowsCount();
                        }
                        return writeStream.appendRows(offset, protoRows);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, contexts -> {
                    LOG.info("Append to stream " + this.streamName + " failed with error " + ((RetryManager.Operation.Context)Iterables.getFirst((Iterable)contexts, null)).getError());
                    this.invalidateWriteStream();
                    this.appendFailures.inc();
                    return RetryManager.RetryType.RETRY_ALL_OPERATIONS;
                }, response -> this.recordsAppended.inc((long)protoRows.getSerializedRowsCount()), new RetryManager.Operation.Context());
            }
        }
    }

    private static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

