/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.joda.time.Duration;

final class AutoValue_SubscriberOptions
extends SubscriberOptions {
    private final SubscriptionPath subscriptionPath;
    private final FlowControlSettings flowControlSettings;
    private final Duration minBundleTimeout;
    private static final long serialVersionUID = 269598118L;

    private AutoValue_SubscriberOptions(SubscriptionPath subscriptionPath, FlowControlSettings flowControlSettings, Duration minBundleTimeout) {
        this.subscriptionPath = subscriptionPath;
        this.flowControlSettings = flowControlSettings;
        this.minBundleTimeout = minBundleTimeout;
    }

    @Override
    public SubscriptionPath subscriptionPath() {
        return this.subscriptionPath;
    }

    @Override
    public FlowControlSettings flowControlSettings() {
        return this.flowControlSettings;
    }

    @Override
    public Duration minBundleTimeout() {
        return this.minBundleTimeout;
    }

    public String toString() {
        return "SubscriberOptions{subscriptionPath=" + this.subscriptionPath + ", flowControlSettings=" + this.flowControlSettings + ", minBundleTimeout=" + this.minBundleTimeout + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriberOptions) {
            SubscriberOptions that = (SubscriberOptions)o;
            return this.subscriptionPath.equals(that.subscriptionPath()) && this.flowControlSettings.equals(that.flowControlSettings()) && this.minBundleTimeout.equals((Object)that.minBundleTimeout());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subscriptionPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.flowControlSettings.hashCode();
        h$ *= 1000003;
        return h$ ^= this.minBundleTimeout.hashCode();
    }

    @Override
    public SubscriberOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SubscriberOptions.Builder {
        private SubscriptionPath subscriptionPath;
        private FlowControlSettings flowControlSettings;
        private Duration minBundleTimeout;

        Builder() {
        }

        private Builder(SubscriberOptions source) {
            this.subscriptionPath = source.subscriptionPath();
            this.flowControlSettings = source.flowControlSettings();
            this.minBundleTimeout = source.minBundleTimeout();
        }

        @Override
        public SubscriberOptions.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
            if (subscriptionPath == null) {
                throw new NullPointerException("Null subscriptionPath");
            }
            this.subscriptionPath = subscriptionPath;
            return this;
        }

        @Override
        public SubscriberOptions.Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
            if (flowControlSettings == null) {
                throw new NullPointerException("Null flowControlSettings");
            }
            this.flowControlSettings = flowControlSettings;
            return this;
        }

        @Override
        public SubscriberOptions.Builder setMinBundleTimeout(Duration minBundleTimeout) {
            if (minBundleTimeout == null) {
                throw new NullPointerException("Null minBundleTimeout");
            }
            this.minBundleTimeout = minBundleTimeout;
            return this;
        }

        @Override
        public SubscriberOptions build() {
            if (this.subscriptionPath == null || this.flowControlSettings == null || this.minBundleTimeout == null) {
                StringBuilder missing = new StringBuilder();
                if (this.subscriptionPath == null) {
                    missing.append(" subscriptionPath");
                }
                if (this.flowControlSettings == null) {
                    missing.append(" flowControlSettings");
                }
                if (this.minBundleTimeout == null) {
                    missing.append(" minBundleTimeout");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SubscriberOptions(this.subscriptionPath, this.flowControlSettings, this.minBundleTimeout);
        }
    }
}

