/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;

class BigQueryResourceNaming {
    BigQueryResourceNaming() {
    }

    static String createJobIdWithDestination(String prefix, TableDestination tableDestination, int partition, long index) {
        String destinationHash = Hashing.murmur3_128().hashUnencodedChars((CharSequence)tableDestination.toString()).toString();
        String jobId = String.format("%s_%s", prefix, destinationHash);
        if (partition >= 0) {
            jobId = jobId + String.format("_%05d", partition);
        }
        if (index >= 0L) {
            jobId = jobId + String.format("_%05d", index);
        }
        return jobId;
    }

    static String createJobIdPrefix(String jobName, String stepUuid, JobType type, String random) {
        jobName = jobName.replaceAll("-", "");
        String result = "beam_bq_job_{TYPE}_{JOB_ID}_{STEP}_{RANDOM}".replaceFirst("\\{TYPE}", type.toString()).replaceFirst("\\{JOB_ID}", jobName).replaceFirst("\\{STEP}", stepUuid);
        if (random != null) {
            return result.replaceFirst("\\{RANDOM}", random);
        }
        return result.replaceFirst("_\\{RANDOM}", "");
    }

    static String createJobIdPrefix(String jobName, String stepUuid, JobType type) {
        return BigQueryResourceNaming.createJobIdPrefix(jobName, stepUuid, type, null);
    }

    static TableReference createTempTableReference(String projectId, String jobUuid, Optional<String> tempDatasetIdOpt) {
        String tempDatasetId = tempDatasetIdOpt.orElse("temp_dataset_" + jobUuid);
        String queryTempTableId = "temp_table_" + jobUuid;
        return new TableReference().setProjectId(projectId).setDatasetId(tempDatasetId).setTableId(queryTempTableId);
    }

    public static enum JobType {
        LOAD,
        TEMP_TABLE_LOAD,
        COPY,
        EXPORT,
        QUERY;

    }
}

