/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.core.ApiService;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.internal.wire.ApiServiceUtils;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.HashMap;
import java.util.function.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceCache<K, V extends ApiService>
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(ServiceCache.class);
    @GuardedBy(value="this")
    private final HashMap<K, V> liveMap = new HashMap();

    ServiceCache() {
    }

    private synchronized void evict(K key, V service) {
        this.liveMap.remove(key, service);
    }

    synchronized V get(final K key, Supplier<V> factory) throws ApiException {
        ApiService service = (ApiService)this.liveMap.get(key);
        if (service != null) {
            return (V)service;
        }
        final ApiService newService = (ApiService)factory.get();
        this.liveMap.put(key, newService);
        newService.addListener(new ApiService.Listener(){

            public void failed(ApiService.State s, Throwable t) {
                ServiceCache.this.logger.warn(newService.getClass().getSimpleName() + " failed.", t);
                ServiceCache.this.evict(key, newService);
            }

            public void terminated(ApiService.State from) {
                ServiceCache.this.evict(key, newService);
            }
        }, SystemExecutors.getFuturesExecutor());
        newService.startAsync().awaitRunning();
        return (V)newService;
    }

    @VisibleForTesting
    synchronized void set(K key, V service) {
        this.liveMap.put(key, service);
    }

    @Override
    public synchronized void close() {
        ApiServiceUtils.blockingShutdown(this.liveMap.values());
        this.liveMap.clear();
    }
}

