/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.TestBigQueryOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestBigQuery
implements TestRule {
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter DATETIME_FORMAT = DateTimeFormat.forPattern((String)"YYYY_MM_dd_HH_mm_ss_SSS");
    private @UnknownKeyFor @NonNull @Initialized TestBigQueryOptions pipelineOptions;
    private @UnknownKeyFor @NonNull @Initialized Schema schema;
    private @Nullable @UnknownKeyFor @Initialized Table table = null;
    private @Nullable @UnknownKeyFor @Initialized BigQueryServices.DatasetService datasetService = null;

    public static @UnknownKeyFor @NonNull @Initialized TestBigQuery create(@UnknownKeyFor @NonNull @Initialized Schema tableSchema) {
        return new TestBigQuery((TestBigQueryOptions)TestPipeline.testingPipelineOptions().as(TestBigQueryOptions.class), tableSchema);
    }

    private TestBigQuery(@UnknownKeyFor @NonNull @Initialized TestBigQueryOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized Schema tableSchema) {
        this.pipelineOptions = pipelineOptions;
        this.schema = tableSchema;
    }

    public @UnknownKeyFor @NonNull @Initialized Statement apply(final @UnknownKeyFor @NonNull @Initialized Statement base, final @UnknownKeyFor @NonNull @Initialized Description description) {
        return new Statement(){

            public void evaluate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                if (TestBigQuery.this.datasetService != null) {
                    throw new AssertionError((Object)("BigQuery test was not shutdown previously. Table is'" + TestBigQuery.this.table + "'. Current test: " + description.getDisplayName()));
                }
                try {
                    TestBigQuery.this.initializeBigQuery(description);
                    base.evaluate();
                }
                finally {
                    TestBigQuery.this.tearDown();
                }
            }
        };
    }

    private void initializeBigQuery(@UnknownKeyFor @NonNull @Initialized Description description) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        this.datasetService = new BigQueryServicesImpl().getDatasetService(this.pipelineOptions);
        this.table = this.createTable(description);
    }

    @RequiresNonNull(value={"datasetService"})
    private @UnknownKeyFor @NonNull @Initialized Table createTable(@UnknownKeyFor @NonNull @Initialized Description description) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        BigQueryServices.DatasetService datasetService = this.datasetService;
        TableReference tableReference = new TableReference().setProjectId(this.pipelineOptions.getBigQueryProject() == null ? this.pipelineOptions.getProject() : this.pipelineOptions.getBigQueryProject()).setDatasetId(this.pipelineOptions.getTargetDataset()).setTableId(TestBigQuery.createRandomizedName(description));
        Table newTable = new Table().setTableReference(tableReference).setSchema(BigQueryUtils.toTableSchema(this.schema)).setDescription("Table created for " + description.getDisplayName() + " by TestBigQueryRule. Should be automatically cleaned up after test completion.");
        if (datasetService.getTable(tableReference) != null) {
            throw new IllegalStateException("Table '" + tableReference + "' already exists. It should have been cleaned up by the test rule.");
        }
        datasetService.createTable(newTable);
        this.table = newTable;
        return this.table;
    }

    private void tearDown() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        if (this.datasetService == null) {
            return;
        }
        try {
            if (this.table != null) {
                this.datasetService.deleteTable(this.table.getTableReference());
            }
        }
        finally {
            this.datasetService = null;
            this.table = null;
        }
    }

    static @UnknownKeyFor @NonNull @Initialized String createRandomizedName(@UnknownKeyFor @NonNull @Initialized Description description) throws @UnknownKeyFor @NonNull @Initialized IOException {
        StringBuilder topicName = new StringBuilder();
        if (description.getClassName() != null) {
            try {
                topicName.append(Class.forName(description.getClassName()).getSimpleName()).append("_");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (description.getMethodName() != null) {
            topicName.append(description.getMethodName().replaceAll("[\\[\\]\\.]", "_")).append("_");
        }
        DATETIME_FORMAT.printTo(topicName, (ReadableInstant)Instant.now());
        long randomNumber = ThreadLocalRandom.current().nextLong();
        randomNumber = randomNumber == Long.MIN_VALUE ? 0L : Math.abs(randomNumber);
        return topicName.toString() + "_" + String.valueOf(randomNumber);
    }

    @RequiresNonNull(value={"table"})
    public @UnknownKeyFor @NonNull @Initialized String tableSpec() {
        Table table = this.table;
        return String.format("%s:%s.%s", table.getTableReference().getProjectId(), table.getTableReference().getDatasetId(), table.getTableReference().getTableId());
    }

    @RequiresNonNull(value={"table"})
    public @UnknownKeyFor @NonNull @Initialized TableReference tableReference() {
        return this.table.getTableReference();
    }

    @RequiresNonNull(value={"table"})
    public @UnknownKeyFor @NonNull @Initialized TableDataInsertAllResponse insertRows(@UnknownKeyFor @NonNull @Initialized Schema rowSchema, Row ... rows) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Table table = this.table;
        List bqRows = (List)Arrays.stream(rows).map(row -> new TableDataInsertAllRequest.Rows().setJson((Map)BigQueryUtils.toTableRow(row))).collect(ImmutableList.toImmutableList());
        Bigquery bq = TestBigQuery.newBigQueryClient(this.pipelineOptions);
        return (TableDataInsertAllResponse)bq.tabledata().insertAll(this.pipelineOptions.getBigQueryProject() == null ? this.pipelineOptions.getProject() : this.pipelineOptions.getBigQueryProject(), this.pipelineOptions.getTargetDataset(), table.getTableReference().getTableId(), new TableDataInsertAllRequest().setRows(bqRows)).setPrettyPrint(Boolean.valueOf(false)).execute();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> getFlatJsonRows(@UnknownKeyFor @NonNull @Initialized Schema rowSchema) {
        Bigquery bq = TestBigQuery.newBigQueryClient(this.pipelineOptions);
        Preconditions.checkStateNotNull((Object)this.table);
        return this.bqRowsToBeamRows(this.getSchema(bq), this.getTableRows(bq), rowSchema);
    }

    public @UnknownKeyFor @NonNull @Initialized TestBigQuery. @UnknownKeyFor @NonNull @Initialized RowsAssertion assertThatAllRows(@UnknownKeyFor @NonNull @Initialized Schema rowSchema) {
        return new RowsAssertion(rowSchema);
    }

    private void pollAndAssert(@UnknownKeyFor @NonNull @Initialized Schema rowSchema, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Row>> matcher, @UnknownKeyFor @NonNull @Initialized Duration duration) {
        DateTime start = DateTime.now();
        while (true) {
            try {
                this.doAssert(rowSchema, matcher);
            }
            catch (AssertionError assertionError) {
                if (Seconds.secondsBetween((ReadableInstant)start, (ReadableInstant)DateTime.now()).isGreaterThan(duration.toStandardSeconds())) {
                    throw assertionError;
                }
                this.sleep(15000L);
                continue;
            }
            break;
        }
    }

    private void doAssert(@UnknownKeyFor @NonNull @Initialized Schema rowSchema, @UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Row>> matcher) {
        MatcherAssert.assertThat(this.getFlatJsonRows(rowSchema), matcher);
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Row> bqRowsToBeamRows(@UnknownKeyFor @NonNull @Initialized TableSchema bqSchema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> bqRows, @UnknownKeyFor @NonNull @Initialized Schema rowSchema) {
        if (bqRows == null) {
            return Collections.emptyList();
        }
        return bqRows.stream().map(bqRow -> BigQueryUtils.toBeamRow(rowSchema, bqSchema, bqRow)).collect(Collectors.toList());
    }

    @RequiresNonNull(value={"table"})
    @SideEffectFree
    private @UnknownKeyFor @NonNull @Initialized TableSchema getSchema(@UnknownKeyFor @NonNull @Initialized Bigquery bq) {
        Table table = this.table;
        try {
            return ((Table)bq.tables().get(this.pipelineOptions.getBigQueryProject() == null ? this.pipelineOptions.getProject() : this.pipelineOptions.getBigQueryProject(), this.pipelineOptions.getTargetDataset(), table.getTableReference().getTableId()).setPrettyPrint(Boolean.valueOf(false)).execute()).getSchema();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequiresNonNull(value={"table"})
    @SideEffectFree
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> getTableRows(@UnknownKeyFor @NonNull @Initialized Bigquery bq) {
        Table table = this.table;
        try {
            return ((TableDataList)bq.tabledata().list(this.pipelineOptions.getBigQueryProject() == null ? this.pipelineOptions.getProject() : this.pipelineOptions.getBigQueryProject(), this.pipelineOptions.getTargetDataset(), table.getTableReference().getTableId()).setPrettyPrint(Boolean.valueOf(false)).execute()).getRows();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Bigquery newBigQueryClient(@UnknownKeyFor @NonNull @Initialized BigQueryOptions options) {
        return new Bigquery.Builder(Transport.getTransport(), Transport.getJsonFactory(), TestBigQuery.chainHttpRequestInitializer(options.getGcpCredential(), (HttpRequestInitializer)new RetryHttpRequestInitializer((Collection)ImmutableList.of((Object)404)))).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace()).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer chainHttpRequestInitializer(@UnknownKeyFor @NonNull @Initialized Credentials credential, @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer httpRequestInitializer) {
        if (credential == null) {
            return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new NullCredentialInitializer(), httpRequestInitializer});
        }
        return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), httpRequestInitializer});
    }

    private void sleep(@UnknownKeyFor @NonNull @Initialized long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface PollingAssertion {
        public void pollFor(@UnknownKeyFor @NonNull @Initialized Duration var1);
    }

    public class RowsAssertion {
        private final @UnknownKeyFor @NonNull @Initialized Schema rowSchema;

        private RowsAssertion(Schema rowSchema) {
            this.rowSchema = rowSchema;
        }

        public @UnknownKeyFor @NonNull @Initialized PollingAssertion eventually(@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Row>> matcher) {
            return duration -> TestBigQuery.this.pollAndAssert(this.rowSchema, (Matcher<Iterable<? extends Row>>)matcher, duration);
        }

        public void now(@UnknownKeyFor @NonNull @Initialized Matcher<@UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Row>> matcher) {
            TestBigQuery.this.doAssert(this.rowSchema, (Matcher<Iterable<? extends Row>>)matcher);
        }
    }
}

