/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.Query;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreV1;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

final class AutoValue_DatastoreV1_Read
extends DatastoreV1.Read {
    private final @Nullable ValueProvider<String> projectId;
    private final @Nullable Query query;
    private final @Nullable ValueProvider<String> literalGqlQuery;
    private final @Nullable ValueProvider<String> namespace;
    private final int numQuerySplits;
    private final @Nullable String localhost;
    private final @Nullable Instant readTime;

    private AutoValue_DatastoreV1_Read(@Nullable ValueProvider<String> projectId, @Nullable Query query, @Nullable ValueProvider<String> literalGqlQuery, @Nullable ValueProvider<String> namespace, int numQuerySplits, @Nullable String localhost, @Nullable Instant readTime) {
        this.projectId = projectId;
        this.query = query;
        this.literalGqlQuery = literalGqlQuery;
        this.namespace = namespace;
        this.numQuerySplits = numQuerySplits;
        this.localhost = localhost;
        this.readTime = readTime;
    }

    @Override
    public @Nullable ValueProvider<String> getProjectId() {
        return this.projectId;
    }

    @Override
    public @Nullable Query getQuery() {
        return this.query;
    }

    @Override
    public @Nullable ValueProvider<String> getLiteralGqlQuery() {
        return this.literalGqlQuery;
    }

    @Override
    public @Nullable ValueProvider<String> getNamespace() {
        return this.namespace;
    }

    @Override
    public int getNumQuerySplits() {
        return this.numQuerySplits;
    }

    @Override
    public @Nullable String getLocalhost() {
        return this.localhost;
    }

    @Override
    public @Nullable Instant getReadTime() {
        return this.readTime;
    }

    @Override
    public String toString() {
        return "Read{projectId=" + this.projectId + ", query=" + this.query + ", literalGqlQuery=" + this.literalGqlQuery + ", namespace=" + this.namespace + ", numQuerySplits=" + this.numQuerySplits + ", localhost=" + this.localhost + ", readTime=" + this.readTime + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DatastoreV1.Read) {
            DatastoreV1.Read that = (DatastoreV1.Read)((Object)o);
            return (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId())) && (this.query == null ? that.getQuery() == null : this.query.equals((Object)that.getQuery())) && (this.literalGqlQuery == null ? that.getLiteralGqlQuery() == null : this.literalGqlQuery.equals(that.getLiteralGqlQuery())) && (this.namespace == null ? that.getNamespace() == null : this.namespace.equals(that.getNamespace())) && this.numQuerySplits == that.getNumQuerySplits() && (this.localhost == null ? that.getLocalhost() == null : this.localhost.equals(that.getLocalhost())) && (this.readTime == null ? that.getReadTime() == null : this.readTime.equals((Object)that.getReadTime()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.projectId == null ? 0 : this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.query == null ? 0 : this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.literalGqlQuery == null ? 0 : this.literalGqlQuery.hashCode();
        h$ *= 1000003;
        h$ ^= this.namespace == null ? 0 : this.namespace.hashCode();
        h$ *= 1000003;
        h$ ^= this.numQuerySplits;
        h$ *= 1000003;
        h$ ^= this.localhost == null ? 0 : this.localhost.hashCode();
        h$ *= 1000003;
        return h$ ^= this.readTime == null ? 0 : this.readTime.hashCode();
    }

    @Override
    DatastoreV1.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends DatastoreV1.Read.Builder {
        private @Nullable ValueProvider<String> projectId;
        private @Nullable Query query;
        private @Nullable ValueProvider<String> literalGqlQuery;
        private @Nullable ValueProvider<String> namespace;
        private Integer numQuerySplits;
        private @Nullable String localhost;
        private @Nullable Instant readTime;

        Builder() {
        }

        private Builder(DatastoreV1.Read source) {
            this.projectId = source.getProjectId();
            this.query = source.getQuery();
            this.literalGqlQuery = source.getLiteralGqlQuery();
            this.namespace = source.getNamespace();
            this.numQuerySplits = source.getNumQuerySplits();
            this.localhost = source.getLocalhost();
            this.readTime = source.getReadTime();
        }

        @Override
        DatastoreV1.Read.Builder setProjectId(ValueProvider<String> projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        DatastoreV1.Read.Builder setQuery(Query query) {
            this.query = query;
            return this;
        }

        @Override
        DatastoreV1.Read.Builder setLiteralGqlQuery(ValueProvider<String> literalGqlQuery) {
            this.literalGqlQuery = literalGqlQuery;
            return this;
        }

        @Override
        DatastoreV1.Read.Builder setNamespace(ValueProvider<String> namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        DatastoreV1.Read.Builder setNumQuerySplits(int numQuerySplits) {
            this.numQuerySplits = numQuerySplits;
            return this;
        }

        @Override
        DatastoreV1.Read.Builder setLocalhost(String localhost) {
            this.localhost = localhost;
            return this;
        }

        @Override
        DatastoreV1.Read.Builder setReadTime(Instant readTime) {
            this.readTime = readTime;
            return this;
        }

        @Override
        DatastoreV1.Read build() {
            if (this.numQuerySplits == null) {
                String missing = " numQuerySplits";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DatastoreV1_Read(this.projectId, this.query, this.literalGqlQuery, this.namespace, this.numQuerySplits, this.localhost, this.readTime);
        }
    }
}

