/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.Pair;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HBaseSharedConnection
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 5252999807656940415L;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HBaseSharedConnection.class);
    private static @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Pair<@UnknownKeyFor @NonNull @Initialized Connection, @UnknownKeyFor @NonNull @Initialized Integer>> connectionPool = new HashMap();

    HBaseSharedConnection() {
    }

    private static @UnknownKeyFor @NonNull @Initialized String hash(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return configuration.get("hbase.zookeeper.quorum");
    }

    public static synchronized @UnknownKeyFor @NonNull @Initialized Connection getOrCreate(@UnknownKeyFor @NonNull @Initialized Configuration configuration) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String confString = HBaseSharedConnection.hash(configuration);
        if (!connectionPool.containsKey(confString)) {
            connectionPool.put(confString, (Pair<Connection, Integer>)new Pair((Object)ConnectionFactory.createConnection((Configuration)configuration), (Object)0));
        }
        connectionPool.get(confString).setSecond((Object)((Integer)connectionPool.get(confString).getSecond() + 1));
        return (Connection)connectionPool.get(confString).getFirst();
    }

    @Internal
    static synchronized void closeAll() throws @UnknownKeyFor @NonNull @Initialized IOException {
        HashSet<String> set = new HashSet<String>(connectionPool.keySet());
        for (String confString : set) {
            HBaseSharedConnection.closeAll(confString);
        }
    }

    public static synchronized void close(@UnknownKeyFor @NonNull @Initialized Configuration configuration) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String confString = HBaseSharedConnection.hash(configuration);
        HBaseSharedConnection.close(confString);
    }

    private static synchronized void closeAll(@UnknownKeyFor @NonNull @Initialized String confString) throws @UnknownKeyFor @NonNull @Initialized IOException {
        while (connectionPool.containsKey(confString)) {
            HBaseSharedConnection.close(confString);
        }
    }

    private static synchronized void close(@UnknownKeyFor @NonNull @Initialized String confString) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!connectionPool.containsKey(confString)) {
            return;
        }
        connectionPool.get(confString).setSecond((Object)((Integer)connectionPool.get(confString).getSecond() - 1));
        if ((Integer)connectionPool.get(confString).getSecond() < 0) {
            LOG.warn("Connection count for + " + confString + " at below 0, " + HBaseSharedConnection.getDebugString());
            connectionPool.get(confString).setSecond((Object)0);
        }
        if ((Integer)connectionPool.get(confString).getSecond() == 0) {
            ((Connection)connectionPool.get(confString).getFirst()).close();
            connectionPool.remove(confString);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String getDebugString() {
        return String.format("Connection pool status: %s%n", connectionPool);
    }

    public static @UnknownKeyFor @NonNull @Initialized int getConnectionPoolSize() {
        return connectionPool.size();
    }

    public static @UnknownKeyFor @NonNull @Initialized int getConnectionCount(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
        String confString = HBaseSharedConnection.hash(configuration);
        if (!connectionPool.containsKey(confString)) {
            return 0;
        }
        return (Integer)connectionPool.get(confString).getSecond();
    }
}

