/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class HBaseUtils {
    HBaseUtils() {
    }

    static @UnknownKeyFor @NonNull @Initialized long estimateSizeBytes(@UnknownKeyFor @NonNull @Initialized Connection connection, @UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized ByteKeyRange range) throws @UnknownKeyFor @NonNull @Initialized Exception {
        long estimatedSizeBytes = 0L;
        List<HRegionLocation> regionLocations = HBaseUtils.getRegionLocations(connection, tableId, range);
        TreeSet<byte[]> tableRegions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (HRegionLocation regionLocation : regionLocations) {
            tableRegions.add(regionLocation.getRegionInfo().getRegionName());
        }
        Admin admin = connection.getAdmin();
        ClusterStatus clusterStatus = admin.getClusterStatus();
        Collection servers = clusterStatus.getServers();
        for (ServerName serverName : servers) {
            ServerLoad serverLoad = clusterStatus.getLoad(serverName);
            for (RegionLoad regionLoad : serverLoad.getRegionsLoad().values()) {
                byte[] regionId = regionLoad.getName();
                if (!tableRegions.contains(regionId)) continue;
                long regionSizeBytes = (long)regionLoad.getStorefileSizeMB() * 0x100000L;
                estimatedSizeBytes += regionSizeBytes;
            }
        }
        return estimatedSizeBytes;
    }

    static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized HRegionLocation> getRegionLocations(@UnknownKeyFor @NonNull @Initialized Connection connection, @UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized ByteKeyRange range) throws @UnknownKeyFor @NonNull @Initialized Exception {
        byte[] startRow = range.getStartKey().getBytes();
        byte[] stopRow = range.getEndKey().getBytes();
        ArrayList<HRegionLocation> regionLocations = new ArrayList<HRegionLocation>();
        boolean scanWithNoLowerBound = startRow.length == 0;
        boolean scanWithNoUpperBound = stopRow.length == 0;
        TableName tableName = TableName.valueOf((String)tableId);
        RegionLocator regionLocator = connection.getRegionLocator(tableName);
        List tableRegionInfos = regionLocator.getAllRegionLocations();
        for (HRegionLocation regionLocation : tableRegionInfos) {
            boolean isLastRegion;
            byte[] startKey = regionLocation.getRegionInfo().getStartKey();
            byte[] endKey = regionLocation.getRegionInfo().getEndKey();
            boolean bl = isLastRegion = endKey.length == 0;
            if (!scanWithNoLowerBound && !isLastRegion && Bytes.compareTo((byte[])startRow, (byte[])endKey) >= 0 || !scanWithNoUpperBound && Bytes.compareTo((byte[])stopRow, (byte[])startKey) <= 0) continue;
            regionLocations.add(regionLocation);
        }
        return regionLocations;
    }

    static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteKeyRange> getRanges(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized HRegionLocation> regionLocations, @UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized ByteKeyRange range) {
        byte[] startRow = range.getStartKey().getBytes();
        byte[] stopRow = range.getEndKey().getBytes();
        ArrayList<ByteKeyRange> splits = new ArrayList<ByteKeyRange>();
        boolean scanWithNoLowerBound = startRow.length == 0;
        boolean scanWithNoUpperBound = stopRow.length == 0;
        for (HRegionLocation regionLocation : regionLocations) {
            byte[] startKey = regionLocation.getRegionInfo().getStartKey();
            byte[] endKey = regionLocation.getRegionInfo().getEndKey();
            boolean isLastRegion = endKey.length == 0;
            byte[] splitStart = scanWithNoLowerBound || Bytes.compareTo((byte[])startKey, (byte[])startRow) >= 0 ? startKey : startRow;
            byte[] splitStop = (scanWithNoUpperBound || Bytes.compareTo((byte[])endKey, (byte[])stopRow) <= 0) && !isLastRegion ? endKey : stopRow;
            splits.add(ByteKeyRange.of((ByteKey)ByteKey.copyFrom((byte[])splitStart), (ByteKey)ByteKey.copyFrom((byte[])splitStop)));
        }
        return splits;
    }

    static @UnknownKeyFor @NonNull @Initialized ByteKeyRange getByteKeyRange(@UnknownKeyFor @NonNull @Initialized Scan scan) {
        return ByteKeyRange.of((ByteKey)ByteKey.copyFrom((byte[])scan.getStartRow()), (ByteKey)ByteKey.copyFrom((byte[])scan.getStopRow()));
    }

    static @UnknownKeyFor @NonNull @Initialized Scan newScanInRange(@UnknownKeyFor @NonNull @Initialized Scan scan, @UnknownKeyFor @NonNull @Initialized ByteKeyRange range) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new Scan(scan).setStartRow(range.getStartKey().getBytes()).setStopRow(range.getEndKey().getBytes());
    }
}

