/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import javax.sql.DataSource;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_JdbcIO_ReadWithPartitions<T>
extends JdbcIO.ReadWithPartitions<T> {
    private final @Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn;
    private final  @Nullable JdbcIO.RowMapper<T> rowMapper;
    private final @Nullable Coder<T> coder;
    private final int numPartitions;
    private final @Nullable String partitionColumn;
    private final int lowerBound;
    private final int upperBound;
    private final @Nullable String table;

    private AutoValue_JdbcIO_ReadWithPartitions(@Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn,  @Nullable JdbcIO.RowMapper<T> rowMapper, @Nullable Coder<T> coder, int numPartitions, @Nullable String partitionColumn, int lowerBound, int upperBound, @Nullable String table) {
        this.dataSourceProviderFn = dataSourceProviderFn;
        this.rowMapper = rowMapper;
        this.coder = coder;
        this.numPartitions = numPartitions;
        this.partitionColumn = partitionColumn;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.table = table;
    }

    @Override
    @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn() {
        return this.dataSourceProviderFn;
    }

    @Override
     @Nullable JdbcIO.RowMapper<T> getRowMapper() {
        return this.rowMapper;
    }

    @Override
    @Nullable Coder<T> getCoder() {
        return this.coder;
    }

    @Override
    int getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    @Nullable String getPartitionColumn() {
        return this.partitionColumn;
    }

    @Override
    int getLowerBound() {
        return this.lowerBound;
    }

    @Override
    int getUpperBound() {
        return this.upperBound;
    }

    @Override
    @Nullable String getTable() {
        return this.table;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JdbcIO.ReadWithPartitions) {
            JdbcIO.ReadWithPartitions that = (JdbcIO.ReadWithPartitions)((Object)o);
            return (this.dataSourceProviderFn == null ? that.getDataSourceProviderFn() == null : this.dataSourceProviderFn.equals(that.getDataSourceProviderFn())) && (this.rowMapper == null ? that.getRowMapper() == null : this.rowMapper.equals(that.getRowMapper())) && (this.coder == null ? that.getCoder() == null : this.coder.equals(that.getCoder())) && this.numPartitions == that.getNumPartitions() && (this.partitionColumn == null ? that.getPartitionColumn() == null : this.partitionColumn.equals(that.getPartitionColumn())) && this.lowerBound == that.getLowerBound() && this.upperBound == that.getUpperBound() && (this.table == null ? that.getTable() == null : this.table.equals(that.getTable()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.dataSourceProviderFn == null ? 0 : this.dataSourceProviderFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.rowMapper == null ? 0 : this.rowMapper.hashCode();
        h$ *= 1000003;
        h$ ^= this.coder == null ? 0 : this.coder.hashCode();
        h$ *= 1000003;
        h$ ^= this.numPartitions;
        h$ *= 1000003;
        h$ ^= this.partitionColumn == null ? 0 : this.partitionColumn.hashCode();
        h$ *= 1000003;
        h$ ^= this.lowerBound;
        h$ *= 1000003;
        h$ ^= this.upperBound;
        h$ *= 1000003;
        return h$ ^= this.table == null ? 0 : this.table.hashCode();
    }

    @Override
    JdbcIO.ReadWithPartitions.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends JdbcIO.ReadWithPartitions.Builder<T> {
        private @Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn;
        private  @Nullable JdbcIO.RowMapper<T> rowMapper;
        private @Nullable Coder<T> coder;
        private Integer numPartitions;
        private @Nullable String partitionColumn;
        private Integer lowerBound;
        private Integer upperBound;
        private @Nullable String table;

        Builder() {
        }

        private Builder(JdbcIO.ReadWithPartitions<T> source) {
            this.dataSourceProviderFn = source.getDataSourceProviderFn();
            this.rowMapper = source.getRowMapper();
            this.coder = source.getCoder();
            this.numPartitions = source.getNumPartitions();
            this.partitionColumn = source.getPartitionColumn();
            this.lowerBound = source.getLowerBound();
            this.upperBound = source.getUpperBound();
            this.table = source.getTable();
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T> setDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T> setRowMapper(JdbcIO.RowMapper<T> rowMapper) {
            this.rowMapper = rowMapper;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T> setCoder(Coder<T> coder) {
            this.coder = coder;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T> setNumPartitions(int numPartitions) {
            this.numPartitions = numPartitions;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T> setPartitionColumn(String partitionColumn) {
            this.partitionColumn = partitionColumn;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T> setLowerBound(int lowerBound) {
            this.lowerBound = lowerBound;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T> setUpperBound(int upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions.Builder<T> setTable(String table) {
            this.table = table;
            return this;
        }

        @Override
        JdbcIO.ReadWithPartitions<T> build() {
            String missing = "";
            if (this.numPartitions == null) {
                missing = missing + " numPartitions";
            }
            if (this.lowerBound == null) {
                missing = missing + " lowerBound";
            }
            if (this.upperBound == null) {
                missing = missing + " upperBound";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_JdbcIO_ReadWithPartitions(this.dataSourceProviderFn, this.rowMapper, this.coder, this.numPartitions, this.partitionColumn, this.lowerBound, this.upperBound, this.table);
        }
    }
}

