/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import javax.sql.DataSource;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

final class AutoValue_JdbcIO_ReadAll<ParameterT, OutputT>
extends JdbcIO.ReadAll<ParameterT, OutputT> {
    private final @Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn;
    private final @Nullable ValueProvider<String> query;
    private final @Nullable JdbcIO.PreparedStatementSetter<ParameterT> parameterSetter;
    private final @Nullable JdbcIO.RowMapper<OutputT> rowMapper;
    private final @Nullable Coder<OutputT> coder;
    private final int fetchSize;
    private final boolean outputParallelization;

    private AutoValue_JdbcIO_ReadAll(@Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn, @Nullable ValueProvider<String> query, @Nullable JdbcIO.PreparedStatementSetter<ParameterT> parameterSetter, @Nullable JdbcIO.RowMapper<OutputT> rowMapper, @Nullable Coder<OutputT> coder, int fetchSize, boolean outputParallelization) {
        this.dataSourceProviderFn = dataSourceProviderFn;
        this.query = query;
        this.parameterSetter = parameterSetter;
        this.rowMapper = rowMapper;
        this.coder = coder;
        this.fetchSize = fetchSize;
        this.outputParallelization = outputParallelization;
    }

    @Override
    @Pure
    @Nullable SerializableFunction<Void, DataSource> getDataSourceProviderFn() {
        return this.dataSourceProviderFn;
    }

    @Override
    @Pure
    @Nullable ValueProvider<String> getQuery() {
        return this.query;
    }

    @Override
    @Pure
    @Nullable JdbcIO.PreparedStatementSetter<ParameterT> getParameterSetter() {
        return this.parameterSetter;
    }

    @Override
    @Pure
    @Nullable JdbcIO.RowMapper<OutputT> getRowMapper() {
        return this.rowMapper;
    }

    @Override
    @Pure
    @Nullable Coder<OutputT> getCoder() {
        return this.coder;
    }

    @Override
    int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    boolean getOutputParallelization() {
        return this.outputParallelization;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JdbcIO.ReadAll) {
            JdbcIO.ReadAll that = (JdbcIO.ReadAll)((Object)o);
            return (this.dataSourceProviderFn == null ? that.getDataSourceProviderFn() == null : this.dataSourceProviderFn.equals(that.getDataSourceProviderFn())) && (this.query == null ? that.getQuery() == null : this.query.equals(that.getQuery())) && (this.parameterSetter == null ? that.getParameterSetter() == null : this.parameterSetter.equals(that.getParameterSetter())) && (this.rowMapper == null ? that.getRowMapper() == null : this.rowMapper.equals(that.getRowMapper())) && (this.coder == null ? that.getCoder() == null : this.coder.equals(that.getCoder())) && this.fetchSize == that.getFetchSize() && this.outputParallelization == that.getOutputParallelization();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.dataSourceProviderFn == null ? 0 : this.dataSourceProviderFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.query == null ? 0 : this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.parameterSetter == null ? 0 : this.parameterSetter.hashCode();
        h$ *= 1000003;
        h$ ^= this.rowMapper == null ? 0 : this.rowMapper.hashCode();
        h$ *= 1000003;
        h$ ^= this.coder == null ? 0 : this.coder.hashCode();
        h$ *= 1000003;
        h$ ^= this.fetchSize;
        h$ *= 1000003;
        return h$ ^= this.outputParallelization ? 1231 : 1237;
    }

    @Override
    JdbcIO.ReadAll.Builder<ParameterT, OutputT> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<ParameterT, OutputT>
    extends JdbcIO.ReadAll.Builder<ParameterT, OutputT> {
        private @Nullable SerializableFunction<Void, DataSource> dataSourceProviderFn;
        private @Nullable ValueProvider<String> query;
        private @Nullable JdbcIO.PreparedStatementSetter<ParameterT> parameterSetter;
        private @Nullable JdbcIO.RowMapper<OutputT> rowMapper;
        private @Nullable Coder<OutputT> coder;
        private Integer fetchSize;
        private Boolean outputParallelization;

        Builder() {
        }

        private Builder(JdbcIO.ReadAll<ParameterT, OutputT> source) {
            this.dataSourceProviderFn = source.getDataSourceProviderFn();
            this.query = source.getQuery();
            this.parameterSetter = source.getParameterSetter();
            this.rowMapper = source.getRowMapper();
            this.coder = source.getCoder();
            this.fetchSize = source.getFetchSize();
            this.outputParallelization = source.getOutputParallelization();
        }

        @Override
        JdbcIO.ReadAll.Builder<ParameterT, OutputT> setDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            return this;
        }

        @Override
        JdbcIO.ReadAll.Builder<ParameterT, OutputT> setQuery(ValueProvider<String> query) {
            this.query = query;
            return this;
        }

        @Override
        JdbcIO.ReadAll.Builder<ParameterT, OutputT> setParameterSetter(JdbcIO.PreparedStatementSetter<ParameterT> parameterSetter) {
            this.parameterSetter = parameterSetter;
            return this;
        }

        @Override
        JdbcIO.ReadAll.Builder<ParameterT, OutputT> setRowMapper(JdbcIO.RowMapper<OutputT> rowMapper) {
            this.rowMapper = rowMapper;
            return this;
        }

        @Override
        JdbcIO.ReadAll.Builder<ParameterT, OutputT> setCoder(Coder<OutputT> coder) {
            this.coder = coder;
            return this;
        }

        @Override
        JdbcIO.ReadAll.Builder<ParameterT, OutputT> setFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        @Override
        JdbcIO.ReadAll.Builder<ParameterT, OutputT> setOutputParallelization(boolean outputParallelization) {
            this.outputParallelization = outputParallelization;
            return this;
        }

        @Override
        JdbcIO.ReadAll<ParameterT, OutputT> build() {
            if (this.fetchSize == null || this.outputParallelization == null) {
                StringBuilder missing = new StringBuilder();
                if (this.fetchSize == null) {
                    missing.append(" fetchSize");
                }
                if (this.outputParallelization == null) {
                    missing.append(" outputParallelization");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_JdbcIO_ReadAll(this.dataSourceProviderFn, this.query, this.parameterSetter, this.rowMapper, this.coder, this.fetchSize, this.outputParallelization);
        }
    }
}

