/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.kafka.ConsumerSpEL;
import org.apache.beam.sdk.values.KV;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class ProducerRecordCoder<K, V>
extends StructuredCoder<ProducerRecord<K, V>> {
    private static final StringUtf8Coder stringCoder = StringUtf8Coder.of();
    private static final VarLongCoder longCoder = VarLongCoder.of();
    private static final VarIntCoder intCoder = VarIntCoder.of();
    private static final IterableCoder headerCoder = IterableCoder.of((Coder)KvCoder.of((Coder)stringCoder, (Coder)ByteArrayCoder.of()));
    private final KvCoder<K, V> kvCoder;

    public static <K, V> ProducerRecordCoder<K, V> of(Coder<K> keyCoder, Coder<V> valueCoder) {
        return new ProducerRecordCoder<K, V>(keyCoder, valueCoder);
    }

    public ProducerRecordCoder(Coder<K> keyCoder, Coder<V> valueCoder) {
        this.kvCoder = KvCoder.of(keyCoder, valueCoder);
    }

    public void encode(ProducerRecord<K, V> value, OutputStream outStream) throws IOException {
        stringCoder.encode(value.topic(), outStream);
        intCoder.encode(Integer.valueOf(value.partition() != null ? value.partition() : -1), outStream);
        longCoder.encode(Long.valueOf(value.timestamp() != null ? value.timestamp() : Long.MAX_VALUE), outStream);
        headerCoder.encode(this.toIterable(value), outStream);
        this.kvCoder.encode(KV.of((Object)value.key(), (Object)value.value()), outStream);
    }

    public ProducerRecord<K, V> decode(InputStream inStream) throws IOException {
        Long timestamp;
        String topic = stringCoder.decode(inStream);
        Integer partition = intCoder.decode(inStream);
        if (partition == -1) {
            partition = null;
        }
        if ((timestamp = longCoder.decode(inStream)) == Long.MAX_VALUE) {
            timestamp = null;
        }
        Headers headers = (Headers)this.toHeaders(headerCoder.decode(inStream));
        KV kv = this.kvCoder.decode(inStream);
        if (ConsumerSpEL.hasHeaders()) {
            return new ProducerRecord(topic, partition, timestamp, kv.getKey(), kv.getValue(), (Iterable)headers);
        }
        return new ProducerRecord(topic, partition, timestamp, kv.getKey(), kv.getValue());
    }

    private Object toHeaders(Iterable<KV<String, byte[]>> records) {
        if (!ConsumerSpEL.hasHeaders()) {
            return null;
        }
        ConsumerRecord consumerRecord = new ConsumerRecord("", 0, 0L, (Object)"", (Object)"");
        records.forEach(kv -> consumerRecord.headers().add((String)kv.getKey(), (byte[])kv.getValue()));
        return consumerRecord.headers();
    }

    private Iterable<KV<String, byte[]>> toIterable(ProducerRecord record) {
        if (!ConsumerSpEL.hasHeaders()) {
            return Collections.emptyList();
        }
        ArrayList<KV<String, byte[]>> vals = new ArrayList<KV<String, byte[]>>();
        for (Header header : record.headers()) {
            vals.add((KV<String, byte[]>)KV.of((Object)header.key(), (Object)header.value()));
        }
        return vals;
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return this.kvCoder.getCoderArguments();
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.kvCoder.verifyDeterministic();
    }

    public boolean isRegisterByteSizeObserverCheap(ProducerRecord<K, V> value) {
        return this.kvCoder.isRegisterByteSizeObserverCheap(KV.of((Object)value.key(), (Object)value.value()));
    }

    public Object structuralValue(ProducerRecord<K, V> value) {
        if (this.consistentWithEquals()) {
            return value;
        }
        if (!ConsumerSpEL.hasHeaders()) {
            return new ProducerRecord(value.topic(), value.partition(), value.timestamp(), value.key(), value.value());
        }
        return new ProducerRecord(value.topic(), value.partition(), value.timestamp(), value.key(), value.value(), (Iterable)value.headers());
    }

    public boolean consistentWithEquals() {
        return this.kvCoder.consistentWithEquals();
    }
}

