/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import java.util.NoSuchElementException;
import java.util.Objects;

abstract class CustomOptional<T> {
    CustomOptional() {
    }

    public static <T> CustomOptional<T> absent() {
        return Absent.INSTANCE;
    }

    public static <T> CustomOptional<T> of(T v) {
        return new Present(v);
    }

    public abstract boolean isPresent();

    public abstract T get();

    private static class Absent<T>
    extends CustomOptional<T> {
        private static final Absent<Object> INSTANCE = new Absent();

        private Absent() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public T get() {
            throw new NoSuchElementException();
        }

        public boolean equals(Object o) {
            return o instanceof Absent;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class Present<T>
    extends CustomOptional<T> {
        private final T value;

        private Present(T value) {
            this.value = value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Present)) {
                return false;
            }
            Present present = (Present)o;
            return Objects.equals(this.value, present.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

