/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.joda.time.Instant;

public class KinesisRecord {
    private Instant readTime;
    private String streamName;
    private String shardId;
    private long subSequenceNumber;
    private String sequenceNumber;
    private Instant approximateArrivalTimestamp;
    private ByteBuffer data;
    private String partitionKey;

    public KinesisRecord(UserRecord record, String streamName, String shardId) {
        this(record.getData(), record.getSequenceNumber(), record.getSubSequenceNumber(), record.getPartitionKey(), new Instant((Object)record.getApproximateArrivalTimestamp()), Instant.now(), streamName, shardId);
    }

    public KinesisRecord(ByteBuffer data, String sequenceNumber, long subSequenceNumber, String partitionKey, Instant approximateArrivalTimestamp, Instant readTime, String streamName, String shardId) {
        this.data = data;
        this.sequenceNumber = sequenceNumber;
        this.subSequenceNumber = subSequenceNumber;
        this.partitionKey = partitionKey;
        this.approximateArrivalTimestamp = approximateArrivalTimestamp;
        this.readTime = readTime;
        this.streamName = streamName;
        this.shardId = shardId;
    }

    public ExtendedSequenceNumber getExtendedSequenceNumber() {
        return new ExtendedSequenceNumber(this.getSequenceNumber(), Long.valueOf(this.getSubSequenceNumber()));
    }

    public byte[] getUniqueId() {
        return this.getExtendedSequenceNumber().toString().getBytes(StandardCharsets.UTF_8);
    }

    public Instant getReadTime() {
        return this.readTime;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getShardId() {
        return this.shardId;
    }

    public byte[] getDataAsBytes() {
        return this.getData().array();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public long getSubSequenceNumber() {
        return this.subSequenceNumber;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Instant getApproximateArrivalTimestamp() {
        return this.approximateArrivalTimestamp;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }
}

