/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.kinesis.KinesisIO;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.joda.time.Duration;

final class AutoValue_KinesisIO_Read
extends KinesisIO.Read {
    private final String streamName;
    private final StartingPoint initialPosition;
    private final AWSClientsProvider AWSClientsProvider;
    private final long maxNumRecords;
    private final Duration maxReadTime;
    private final Duration upToDateThreshold;

    private AutoValue_KinesisIO_Read(@Nullable String streamName, @Nullable StartingPoint initialPosition, @Nullable AWSClientsProvider AWSClientsProvider2, long maxNumRecords, @Nullable Duration maxReadTime, Duration upToDateThreshold) {
        this.streamName = streamName;
        this.initialPosition = initialPosition;
        this.AWSClientsProvider = AWSClientsProvider2;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
        this.upToDateThreshold = upToDateThreshold;
    }

    @Override
    @Nullable
    String getStreamName() {
        return this.streamName;
    }

    @Override
    @Nullable
    StartingPoint getInitialPosition() {
        return this.initialPosition;
    }

    @Override
    @Nullable
    AWSClientsProvider getAWSClientsProvider() {
        return this.AWSClientsProvider;
    }

    @Override
    long getMaxNumRecords() {
        return this.maxNumRecords;
    }

    @Override
    @Nullable
    Duration getMaxReadTime() {
        return this.maxReadTime;
    }

    @Override
    Duration getUpToDateThreshold() {
        return this.upToDateThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KinesisIO.Read) {
            KinesisIO.Read that = (KinesisIO.Read)((Object)o);
            return (this.streamName == null ? that.getStreamName() == null : this.streamName.equals(that.getStreamName())) && (this.initialPosition == null ? that.getInitialPosition() == null : this.initialPosition.equals(that.getInitialPosition())) && (this.AWSClientsProvider == null ? that.getAWSClientsProvider() == null : this.AWSClientsProvider.equals(that.getAWSClientsProvider())) && this.maxNumRecords == that.getMaxNumRecords() && (this.maxReadTime == null ? that.getMaxReadTime() == null : this.maxReadTime.equals((Object)that.getMaxReadTime())) && this.upToDateThreshold.equals((Object)that.getUpToDateThreshold());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.streamName == null ? 0 : this.streamName.hashCode();
        h *= 1000003;
        h ^= this.initialPosition == null ? 0 : this.initialPosition.hashCode();
        h *= 1000003;
        h ^= this.AWSClientsProvider == null ? 0 : this.AWSClientsProvider.hashCode();
        h *= 1000003;
        h ^= (int)(this.maxNumRecords >>> 32 ^ this.maxNumRecords);
        h *= 1000003;
        h ^= this.maxReadTime == null ? 0 : this.maxReadTime.hashCode();
        h *= 1000003;
        return h ^= this.upToDateThreshold.hashCode();
    }

    @Override
    KinesisIO.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends KinesisIO.Read.Builder {
        private String streamName;
        private StartingPoint initialPosition;
        private AWSClientsProvider AWSClientsProvider;
        private Long maxNumRecords;
        private Duration maxReadTime;
        private Duration upToDateThreshold;

        Builder() {
        }

        private Builder(KinesisIO.Read source) {
            this.streamName = source.getStreamName();
            this.initialPosition = source.getInitialPosition();
            this.AWSClientsProvider = source.getAWSClientsProvider();
            this.maxNumRecords = source.getMaxNumRecords();
            this.maxReadTime = source.getMaxReadTime();
            this.upToDateThreshold = source.getUpToDateThreshold();
        }

        @Override
        KinesisIO.Read.Builder setStreamName(@Nullable String streamName) {
            this.streamName = streamName;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setInitialPosition(@Nullable StartingPoint initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setAWSClientsProvider(@Nullable AWSClientsProvider AWSClientsProvider2) {
            this.AWSClientsProvider = AWSClientsProvider2;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setMaxNumRecords(long maxNumRecords) {
            this.maxNumRecords = maxNumRecords;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setMaxReadTime(@Nullable Duration maxReadTime) {
            this.maxReadTime = maxReadTime;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setUpToDateThreshold(Duration upToDateThreshold) {
            if (upToDateThreshold == null) {
                throw new NullPointerException("Null upToDateThreshold");
            }
            this.upToDateThreshold = upToDateThreshold;
            return this;
        }

        @Override
        KinesisIO.Read build() {
            String missing = "";
            if (this.maxNumRecords == null) {
                missing = missing + " maxNumRecords";
            }
            if (this.upToDateThreshold == null) {
                missing = missing + " upToDateThreshold";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KinesisIO_Read(this.streamName, this.initialPosition, this.AWSClientsProvider, this.maxNumRecords, this.maxReadTime, this.upToDateThreshold);
        }
    }
}

