/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import java.util.stream.Collectors;
import org.apache.beam.sdk.io.kinesis.CheckpointGenerator;
import org.apache.beam.sdk.io.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.apache.beam.sdks.java.io.kinesis.repackaged.com.google.common.base.Preconditions;

class DynamicCheckpointGenerator
implements CheckpointGenerator {
    private final String streamName;
    private final StartingPoint startingPoint;

    public DynamicCheckpointGenerator(String streamName, StartingPoint startingPoint) {
        this.streamName = Preconditions.checkNotNull(streamName, "streamName");
        this.startingPoint = Preconditions.checkNotNull(startingPoint, "startingPoint");
    }

    @Override
    public KinesisReaderCheckpoint generate(SimplifiedKinesisClient kinesis) throws TransientKinesisException {
        return new KinesisReaderCheckpoint(kinesis.listShards(this.streamName).stream().map(shard -> new ShardCheckpoint(this.streamName, shard.getShardId(), this.startingPoint)).collect(Collectors.toList()));
    }

    public String toString() {
        return String.format("Checkpoint generator for %s: %s", this.streamName, this.startingPoint);
    }
}

