/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;

class GetKinesisRecordsResult {
    private final List<KinesisRecord> records;
    private final String nextShardIterator;
    private final long millisBehindLatest;

    public GetKinesisRecordsResult(List<UserRecord> records, String nextShardIterator, long millisBehindLatest, String streamName, String shardId) {
        this.records = records.stream().map(input -> {
            assert (input != null);
            return new KinesisRecord((UserRecord)input, streamName, shardId);
        }).collect(Collectors.toList());
        this.nextShardIterator = nextShardIterator;
        this.millisBehindLatest = millisBehindLatest;
    }

    public List<KinesisRecord> getRecords() {
        return this.records;
    }

    public String getNextShardIterator() {
        return this.nextShardIterator;
    }

    public long getMillisBehindLatest() {
        return this.millisBehindLatest;
    }
}

