/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.google.auto.value.AutoValue;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.kinesis.AutoValue_KinesisIO_Read;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.KinesisSource;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdks.java.io.kinesis.repackaged.com.google.common.base.Preconditions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public final class KinesisIO {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisIO.class);

    public static Read read() {
        return new AutoValue_KinesisIO_Read.Builder().setMaxNumRecords(Long.MAX_VALUE).setUpToDateThreshold(Duration.ZERO).build();
    }

    private static boolean streamExists(AmazonKinesis client, String streamName) {
        try {
            DescribeStreamResult describeStreamResult = client.describeStream(streamName);
            return describeStreamResult != null && describeStreamResult.getSdkHttpMetadata().getHttpStatusCode() == 200;
        }
        catch (Exception e) {
            LOG.warn("Error checking whether stream {} exists.", (Object)streamName, (Object)e);
            return false;
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<KinesisRecord>> {
        @Nullable
        abstract String getStreamName();

        @Nullable
        abstract StartingPoint getInitialPosition();

        @Nullable
        abstract AWSClientsProvider getAWSClientsProvider();

        abstract long getMaxNumRecords();

        @Nullable
        abstract Duration getMaxReadTime();

        abstract Duration getUpToDateThreshold();

        abstract Builder toBuilder();

        public Read withStreamName(String streamName) {
            return this.toBuilder().setStreamName(streamName).build();
        }

        public Read withInitialPositionInStream(InitialPositionInStream initialPosition) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialPosition)).build();
        }

        public Read withInitialTimestampInStream(Instant initialTimestamp) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialTimestamp)).build();
        }

        public Read withAWSClientsProvider(AWSClientsProvider awsClientsProvider) {
            return this.toBuilder().setAWSClientsProvider(awsClientsProvider).build();
        }

        public Read withAWSClientsProvider(String awsAccessKey, String awsSecretKey, Regions region) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, null);
        }

        public Read withAWSClientsProvider(String awsAccessKey, String awsSecretKey, Regions region, String serviceEndpoint) {
            return this.withAWSClientsProvider(new BasicKinesisProvider(awsAccessKey, awsSecretKey, region, serviceEndpoint));
        }

        public Read withMaxNumRecords(long maxNumRecords) {
            Preconditions.checkArgument(maxNumRecords > 0L, "maxNumRecords must be positive, but was: %s", maxNumRecords);
            return this.toBuilder().setMaxNumRecords(maxNumRecords).build();
        }

        public Read withMaxReadTime(Duration maxReadTime) {
            Preconditions.checkArgument(maxReadTime != null, "maxReadTime can not be null");
            return this.toBuilder().setMaxReadTime(maxReadTime).build();
        }

        public Read withUpToDateThreshold(Duration upToDateThreshold) {
            Preconditions.checkArgument(upToDateThreshold != null, "upToDateThreshold can not be null");
            return this.toBuilder().setUpToDateThreshold(upToDateThreshold).build();
        }

        public PCollection<KinesisRecord> expand(PBegin input) {
            Read.Unbounded unbounded;
            Preconditions.checkArgument(KinesisIO.streamExists(this.getAWSClientsProvider().getKinesisClient(), this.getStreamName()), "Stream %s does not exist", (Object)this.getStreamName());
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from((UnboundedSource)new KinesisSource(this.getAWSClientsProvider(), this.getStreamName(), this.getInitialPosition(), this.getUpToDateThreshold()));
            if (this.getMaxNumRecords() < Long.MAX_VALUE || this.getMaxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.getMaxReadTime()).withMaxNumRecords(this.getMaxNumRecords());
            }
            return (PCollection)input.apply((PTransform)transform);
        }

        private static final class BasicKinesisProvider
        implements AWSClientsProvider {
            private final String accessKey;
            private final String secretKey;
            private final Regions region;
            @Nullable
            private final String serviceEndpoint;

            private BasicKinesisProvider(String accessKey, String secretKey, Regions region, @Nullable String serviceEndpoint) {
                Preconditions.checkArgument(accessKey != null, "accessKey can not be null");
                Preconditions.checkArgument(secretKey != null, "secretKey can not be null");
                Preconditions.checkArgument(region != null, "region can not be null");
                this.accessKey = accessKey;
                this.secretKey = secretKey;
                this.region = region;
                this.serviceEndpoint = serviceEndpoint;
            }

            private AWSCredentialsProvider getCredentialsProvider() {
                return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey));
            }

            @Override
            public AmazonKinesis getKinesisClient() {
                AmazonKinesisClientBuilder clientBuilder = (AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials(this.getCredentialsProvider());
                if (this.serviceEndpoint == null) {
                    clientBuilder.withRegion(this.region);
                } else {
                    clientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.serviceEndpoint, this.region.getName()));
                }
                return (AmazonKinesis)clientBuilder.build();
            }

            @Override
            public AmazonCloudWatch getCloudWatchClient() {
                AmazonCloudWatchClientBuilder clientBuilder = (AmazonCloudWatchClientBuilder)AmazonCloudWatchClientBuilder.standard().withCredentials(this.getCredentialsProvider());
                if (this.serviceEndpoint == null) {
                    clientBuilder.withRegion(this.region);
                } else {
                    clientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.serviceEndpoint, this.region.getName()));
                }
                return (AmazonCloudWatch)clientBuilder.build();
            }
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setStreamName(String var1);

            abstract Builder setInitialPosition(StartingPoint var1);

            abstract Builder setAWSClientsProvider(AWSClientsProvider var1);

            abstract Builder setMaxNumRecords(long var1);

            abstract Builder setMaxReadTime(Duration var1);

            abstract Builder setUpToDateThreshold(Duration var1);

            abstract Read build();
        }
    }
}

