/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kinesis.ShardCheckpoint;
import org.apache.beam.sdks.java.io.kinesis.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.io.kinesis.repackaged.com.google.common.collect.Lists;

class KinesisReaderCheckpoint
implements Iterable<ShardCheckpoint>,
UnboundedSource.CheckpointMark,
Serializable {
    private final List<ShardCheckpoint> shardCheckpoints;

    public KinesisReaderCheckpoint(Iterable<ShardCheckpoint> shardCheckpoints) {
        this.shardCheckpoints = ImmutableList.copyOf(shardCheckpoints);
    }

    public List<KinesisReaderCheckpoint> splitInto(int desiredNumSplits) {
        int partitionSize = this.divideAndRoundUp(this.shardCheckpoints.size(), desiredNumSplits);
        ArrayList<KinesisReaderCheckpoint> checkpoints = Lists.newArrayList();
        for (List<ShardCheckpoint> shardPartition : Lists.partition(this.shardCheckpoints, partitionSize)) {
            checkpoints.add(new KinesisReaderCheckpoint(shardPartition));
        }
        return checkpoints;
    }

    private int divideAndRoundUp(int nominator, int denominator) {
        return (nominator + denominator - 1) / denominator;
    }

    public void finalizeCheckpoint() throws IOException {
    }

    public String toString() {
        return this.shardCheckpoints.toString();
    }

    @Override
    public Iterator<ShardCheckpoint> iterator() {
        return this.shardCheckpoints.iterator();
    }
}

