/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.kinesis.KinesisIO;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.WatermarkPolicyFactory;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_KinesisIO_Read<T>
extends KinesisIO.Read<T> {
    private final @Nullable String streamName;
    private final @Nullable StartingPoint initialPosition;
    private final @Nullable AWSClientsProvider AWSClientsProvider;
    private final long maxNumRecords;
    private final @Nullable Duration maxReadTime;
    private final Duration upToDateThreshold;
    private final @Nullable Integer requestRecordsLimit;
    private final WatermarkPolicyFactory watermarkPolicyFactory;
    private final RateLimitPolicyFactory rateLimitPolicyFactory;
    private final Integer maxCapacityPerShard;
    private final Coder<T> coder;
    private final @Nullable SerializableFunction<KinesisRecord, T> parseFn;

    private AutoValue_KinesisIO_Read(@Nullable String streamName, @Nullable StartingPoint initialPosition, @Nullable AWSClientsProvider AWSClientsProvider2, long maxNumRecords, @Nullable Duration maxReadTime, Duration upToDateThreshold, @Nullable Integer requestRecordsLimit, WatermarkPolicyFactory watermarkPolicyFactory, RateLimitPolicyFactory rateLimitPolicyFactory, Integer maxCapacityPerShard, Coder<T> coder, @Nullable SerializableFunction<KinesisRecord, T> parseFn) {
        this.streamName = streamName;
        this.initialPosition = initialPosition;
        this.AWSClientsProvider = AWSClientsProvider2;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
        this.upToDateThreshold = upToDateThreshold;
        this.requestRecordsLimit = requestRecordsLimit;
        this.watermarkPolicyFactory = watermarkPolicyFactory;
        this.rateLimitPolicyFactory = rateLimitPolicyFactory;
        this.maxCapacityPerShard = maxCapacityPerShard;
        this.coder = coder;
        this.parseFn = parseFn;
    }

    @Override
    @Nullable String getStreamName() {
        return this.streamName;
    }

    @Override
    @Nullable StartingPoint getInitialPosition() {
        return this.initialPosition;
    }

    @Override
    @Nullable AWSClientsProvider getAWSClientsProvider() {
        return this.AWSClientsProvider;
    }

    @Override
    long getMaxNumRecords() {
        return this.maxNumRecords;
    }

    @Override
    @Nullable Duration getMaxReadTime() {
        return this.maxReadTime;
    }

    @Override
    Duration getUpToDateThreshold() {
        return this.upToDateThreshold;
    }

    @Override
    @Nullable Integer getRequestRecordsLimit() {
        return this.requestRecordsLimit;
    }

    @Override
    WatermarkPolicyFactory getWatermarkPolicyFactory() {
        return this.watermarkPolicyFactory;
    }

    @Override
    RateLimitPolicyFactory getRateLimitPolicyFactory() {
        return this.rateLimitPolicyFactory;
    }

    @Override
    Integer getMaxCapacityPerShard() {
        return this.maxCapacityPerShard;
    }

    @Override
    Coder<T> getCoder() {
        return this.coder;
    }

    @Override
    @Nullable SerializableFunction<KinesisRecord, T> getParseFn() {
        return this.parseFn;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KinesisIO.Read) {
            KinesisIO.Read that = (KinesisIO.Read)((Object)o);
            return (this.streamName == null ? that.getStreamName() == null : this.streamName.equals(that.getStreamName())) && (this.initialPosition == null ? that.getInitialPosition() == null : this.initialPosition.equals(that.getInitialPosition())) && (this.AWSClientsProvider == null ? that.getAWSClientsProvider() == null : this.AWSClientsProvider.equals(that.getAWSClientsProvider())) && this.maxNumRecords == that.getMaxNumRecords() && (this.maxReadTime == null ? that.getMaxReadTime() == null : this.maxReadTime.equals((Object)that.getMaxReadTime())) && this.upToDateThreshold.equals((Object)that.getUpToDateThreshold()) && (this.requestRecordsLimit == null ? that.getRequestRecordsLimit() == null : this.requestRecordsLimit.equals(that.getRequestRecordsLimit())) && this.watermarkPolicyFactory.equals(that.getWatermarkPolicyFactory()) && this.rateLimitPolicyFactory.equals(that.getRateLimitPolicyFactory()) && this.maxCapacityPerShard.equals(that.getMaxCapacityPerShard()) && this.coder.equals(that.getCoder()) && (this.parseFn == null ? that.getParseFn() == null : this.parseFn.equals(that.getParseFn()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.streamName == null ? 0 : this.streamName.hashCode();
        h$ *= 1000003;
        h$ ^= this.initialPosition == null ? 0 : this.initialPosition.hashCode();
        h$ *= 1000003;
        h$ ^= this.AWSClientsProvider == null ? 0 : this.AWSClientsProvider.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.maxNumRecords >>> 32 ^ this.maxNumRecords);
        h$ *= 1000003;
        h$ ^= this.maxReadTime == null ? 0 : this.maxReadTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.upToDateThreshold.hashCode();
        h$ *= 1000003;
        h$ ^= this.requestRecordsLimit == null ? 0 : this.requestRecordsLimit.hashCode();
        h$ *= 1000003;
        h$ ^= this.watermarkPolicyFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.rateLimitPolicyFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxCapacityPerShard.hashCode();
        h$ *= 1000003;
        h$ ^= this.coder.hashCode();
        h$ *= 1000003;
        return h$ ^= this.parseFn == null ? 0 : this.parseFn.hashCode();
    }

    @Override
    KinesisIO.Read.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends KinesisIO.Read.Builder<T> {
        private @Nullable String streamName;
        private @Nullable StartingPoint initialPosition;
        private @Nullable AWSClientsProvider AWSClientsProvider;
        private Long maxNumRecords;
        private @Nullable Duration maxReadTime;
        private Duration upToDateThreshold;
        private @Nullable Integer requestRecordsLimit;
        private WatermarkPolicyFactory watermarkPolicyFactory;
        private RateLimitPolicyFactory rateLimitPolicyFactory;
        private Integer maxCapacityPerShard;
        private Coder<T> coder;
        private @Nullable SerializableFunction<KinesisRecord, T> parseFn;

        Builder() {
        }

        private Builder(KinesisIO.Read<T> source) {
            this.streamName = source.getStreamName();
            this.initialPosition = source.getInitialPosition();
            this.AWSClientsProvider = source.getAWSClientsProvider();
            this.maxNumRecords = source.getMaxNumRecords();
            this.maxReadTime = source.getMaxReadTime();
            this.upToDateThreshold = source.getUpToDateThreshold();
            this.requestRecordsLimit = source.getRequestRecordsLimit();
            this.watermarkPolicyFactory = source.getWatermarkPolicyFactory();
            this.rateLimitPolicyFactory = source.getRateLimitPolicyFactory();
            this.maxCapacityPerShard = source.getMaxCapacityPerShard();
            this.coder = source.getCoder();
            this.parseFn = source.getParseFn();
        }

        @Override
        KinesisIO.Read.Builder<T> setStreamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        @Override
        KinesisIO.Read.Builder<T> setInitialPosition(StartingPoint initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        @Override
        KinesisIO.Read.Builder<T> setAWSClientsProvider(AWSClientsProvider AWSClientsProvider2) {
            this.AWSClientsProvider = AWSClientsProvider2;
            return this;
        }

        @Override
        KinesisIO.Read.Builder<T> setMaxNumRecords(long maxNumRecords) {
            this.maxNumRecords = maxNumRecords;
            return this;
        }

        @Override
        KinesisIO.Read.Builder<T> setMaxReadTime(Duration maxReadTime) {
            this.maxReadTime = maxReadTime;
            return this;
        }

        @Override
        KinesisIO.Read.Builder<T> setUpToDateThreshold(Duration upToDateThreshold) {
            if (upToDateThreshold == null) {
                throw new NullPointerException("Null upToDateThreshold");
            }
            this.upToDateThreshold = upToDateThreshold;
            return this;
        }

        @Override
        KinesisIO.Read.Builder<T> setRequestRecordsLimit(Integer requestRecordsLimit) {
            this.requestRecordsLimit = requestRecordsLimit;
            return this;
        }

        @Override
        KinesisIO.Read.Builder<T> setWatermarkPolicyFactory(WatermarkPolicyFactory watermarkPolicyFactory) {
            if (watermarkPolicyFactory == null) {
                throw new NullPointerException("Null watermarkPolicyFactory");
            }
            this.watermarkPolicyFactory = watermarkPolicyFactory;
            return this;
        }

        @Override
        KinesisIO.Read.Builder<T> setRateLimitPolicyFactory(RateLimitPolicyFactory rateLimitPolicyFactory) {
            if (rateLimitPolicyFactory == null) {
                throw new NullPointerException("Null rateLimitPolicyFactory");
            }
            this.rateLimitPolicyFactory = rateLimitPolicyFactory;
            return this;
        }

        @Override
        KinesisIO.Read.Builder<T> setMaxCapacityPerShard(Integer maxCapacityPerShard) {
            if (maxCapacityPerShard == null) {
                throw new NullPointerException("Null maxCapacityPerShard");
            }
            this.maxCapacityPerShard = maxCapacityPerShard;
            return this;
        }

        @Override
        KinesisIO.Read.Builder<T> setCoder(Coder<T> coder) {
            if (coder == null) {
                throw new NullPointerException("Null coder");
            }
            this.coder = coder;
            return this;
        }

        @Override
        KinesisIO.Read.Builder<T> setParseFn(SerializableFunction<KinesisRecord, T> parseFn) {
            this.parseFn = parseFn;
            return this;
        }

        @Override
        KinesisIO.Read<T> build() {
            String missing = "";
            if (this.maxNumRecords == null) {
                missing = missing + " maxNumRecords";
            }
            if (this.upToDateThreshold == null) {
                missing = missing + " upToDateThreshold";
            }
            if (this.watermarkPolicyFactory == null) {
                missing = missing + " watermarkPolicyFactory";
            }
            if (this.rateLimitPolicyFactory == null) {
                missing = missing + " rateLimitPolicyFactory";
            }
            if (this.maxCapacityPerShard == null) {
                missing = missing + " maxCapacityPerShard";
            }
            if (this.coder == null) {
                missing = missing + " coder";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KinesisIO_Read(this.streamName, this.initialPosition, this.AWSClientsProvider, this.maxNumRecords, this.maxReadTime, this.upToDateThreshold, this.requestRecordsLimit, this.watermarkPolicyFactory, this.rateLimitPolicyFactory, this.maxCapacityPerShard, this.coder, this.parseFn);
        }
    }
}

