/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadLastConfirmedOp
implements BookkeeperInternalCallbacks.ReadEntryCallback {
    static final Logger LOG = LoggerFactory.getLogger(ReadLastConfirmedOp.class);
    LedgerHandle lh;
    BookieClient bookieClient;
    int numResponsesPending;
    DigestManager.RecoveryData maxRecoveredData;
    volatile boolean completed = false;
    int lastSeenError = -1;
    LastConfirmedDataCallback cb;
    final DistributionSchedule.QuorumCoverageSet coverageSet;
    final List<BookieSocketAddress> currentEnsemble;

    public ReadLastConfirmedOp(LedgerHandle lh, BookieClient bookieClient, List<BookieSocketAddress> ensemble, LastConfirmedDataCallback cb) {
        this.cb = cb;
        this.bookieClient = bookieClient;
        this.maxRecoveredData = new DigestManager.RecoveryData(-1L, 0L);
        this.lh = lh;
        this.numResponsesPending = lh.getLedgerMetadata().getEnsembleSize();
        this.coverageSet = lh.distributionSchedule.getCoverageSet();
        this.currentEnsemble = ensemble;
    }

    public void initiate() {
        for (int i = 0; i < this.currentEnsemble.size(); ++i) {
            this.bookieClient.readEntry(this.currentEnsemble.get(i), this.lh.ledgerId, -1L, this, i, 0);
        }
    }

    public void initiateWithFencing() {
        for (int i = 0; i < this.currentEnsemble.size(); ++i) {
            this.bookieClient.readEntry(this.currentEnsemble.get(i), this.lh.ledgerId, -1L, this, i, 1, this.lh.ledgerKey);
        }
    }

    @Override
    public synchronized void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
        int bookieIndex = (Integer)ctx;
        this.coverageSet.addBookie(bookieIndex, rc);
        --this.numResponsesPending;
        boolean heardValidResponse = false;
        if (rc == 0) {
            try {
                DigestManager.RecoveryData recoveryData = this.lh.macManager.verifyDigestAndReturnLastConfirmed(buffer);
                if (recoveryData.getLastAddConfirmed() > this.maxRecoveredData.getLastAddConfirmed()) {
                    this.maxRecoveredData = recoveryData;
                }
                heardValidResponse = true;
            }
            catch (BKException.BKDigestMatchException e) {
                LOG.error("Mac mismatch for ledger: " + ledgerId + ", entry: " + entryId + " while reading last entry from bookie: " + this.currentEnsemble.get(bookieIndex));
            }
        }
        if (rc == -7 || rc == -13) {
            heardValidResponse = true;
        }
        if (rc == -102 && !this.completed) {
            this.cb.readLastConfirmedDataComplete(rc, this.maxRecoveredData);
            this.completed = true;
        }
        if (!heardValidResponse && 0 != rc) {
            this.lastSeenError = rc;
        }
        if (heardValidResponse && this.coverageSet.checkCovered() && !this.completed) {
            this.completed = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read Complete with enough validResponses for ledger: {}, entry: {}", (Object)ledgerId, (Object)entryId);
            }
            this.cb.readLastConfirmedDataComplete(0, this.maxRecoveredData);
            return;
        }
        if (this.numResponsesPending == 0 && !this.completed) {
            LOG.error("While readLastConfirmed ledger: {} did not hear success responses from all quorums", (Object)ledgerId);
            this.cb.readLastConfirmedDataComplete(this.lastSeenError, this.maxRecoveredData);
        }
    }

    static interface LastConfirmedDataCallback {
        public void readLastConfirmedDataComplete(int var1, DigestManager.RecoveryData var2);
    }
}

