/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.net;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);

    public static String normalizeHostName(String name) {
        try {
            return InetAddress.getByName(name).getHostAddress();
        }
        catch (UnknownHostException e) {
            return name;
        }
    }

    public static List<String> normalizeHostNames(Collection<String> names) {
        ArrayList<String> hostNames = new ArrayList<String>(names.size());
        for (String name : names) {
            hostNames.add(NetUtils.normalizeHostName(name));
        }
        return hostNames;
    }

    public static String resolveNetworkLocation(DNSToSwitchMapping dnsResolver, InetSocketAddress addr) {
        ArrayList<String> names = new ArrayList<String>(1);
        if (dnsResolver.useHostName()) {
            names.add(addr.getHostName());
        } else {
            names.add(addr.getAddress().getHostAddress());
        }
        List<String> rNames = dnsResolver.resolve(names);
        Preconditions.checkNotNull(rNames, (Object)"DNS Resolver should not return null response.");
        Preconditions.checkState((rNames.size() == 1 ? 1 : 0) != 0, (Object)"Expected exactly one element");
        return rNames.get(0);
    }
}

