/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.HttpServerLoader;
import org.apache.bookkeeper.http.HttpServiceProvider;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.server.http.BKHttpServiceProvider;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.configuration.Configuration;

public class HttpService
extends ServerLifecycleComponent {
    public static final String NAME = "http-service";
    private HttpServer server;

    public HttpService(BKHttpServiceProvider provider, BookieConfiguration conf, StatsLogger statsLogger) {
        super(NAME, conf, statsLogger);
        HttpServerLoader.loadHttpServer((Configuration)conf.getServerConf());
        this.server = HttpServerLoader.get();
        Preconditions.checkNotNull((Object)this.server);
        this.server.initialize((HttpServiceProvider)provider);
    }

    protected void doStart() {
        this.server.startServer(((BookieConfiguration)this.conf).getServerConf().getHttpServerPort());
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
        this.server.stopServer();
    }
}

